#include <stdio.h>
#include <string.h>
#include "textureParams.h"
#include "primitives.h"

char line[80];

char *GetLine(FILE *f)
{
  do {
    fgets (line, sizeof (line), f);
  } while (line[0] == '#');
  return line;
}

void main(int argc, char *argv[])
{
  textureParams output;
  int i,offset=0,j,k;
  FILE *f;
  
  argv++; /* Get rid of my name/path */
  argc--;
  for (i=0;i<argc;i++) {
    if (i > sizeof (output)/sizeof (output[0])) {
      fprintf (stderr, "Please enlarge textureParams");
      break;
    }
    for (j=0,k=0;argv[i][j]!='.';j++) {
      output[i].name[k]=argv[i][j];
      k++;
      if (argv[i][j]=='/') k=0;
    }
    output[i].name[k]=0;
    
    output[i].offset = offset;
    f = fopen (argv[i], "r");
    GetLine(f);
    if (line[0]!='P' || (line[1]!='3' && line[1]!='6') ||
        sscanf (GetLine(f), "%d %d", &output[i].w, &output[i].h)!=2) {
      fprintf (stderr, "%s is not a ppm file\n", argv[i]);
    }
    fclose(f);
    offset += output[i].h*TEXTURE_WIDTH;
  }
  memset (output+i,0,sizeof (output) - i*sizeof (output[0]));
  f=fopen(TEXTUREPARAMS_FILE,"w");
  fwrite (output,sizeof (output),1,f);
  fclose(f);
}

