#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdlib.h>
#include <sys/time.h>
#include <unistd.h>
#include <signal.h>
#include <fcntl.h>
#include <string.h>
#include <errno.h>
#include "synchronizer.h"

int *synchClient = NULL;
int numClients = 0; /* Here the server is excluded. */
int serverSock = -1;
int listenSock = -1; /* Only an active server uses this */
int myClientNo;
static int msgBufLen;
static char *oldMsgBuf = NULL, *msgBuf = NULL;
struct timeval lastSynch;
    
void StartCommunications (const char *svr, unsigned short portNo,
  int *downloadSock)
{
  struct sockaddr_in addr;
  struct hostent *he;
  int i, len;
  struct timezone tz;
  //fd_set set;
  //FD_ZERO(&set);
  if (svr == NULL || svr[0] == '\0' || strncasecmp (svr, "alone", 5) != 0) {
    if ((serverSock = socket (AF_INET, SOCK_STREAM, IPPROTO_TCP)) == -1) {
      perror("socket");
      exit(1); /* This should never happen */
    }
    addr.sin_family = AF_INET;
    addr.sin_port = htons (portNo);
    if (svr != NULL && svr[0] != '\0') {
      synchClient = NULL;
      he = gethostbyname (svr);
      if (he == NULL) {
        fprintf (stderr, "Unknown host %s.\n", svr);
        exit (2);
      }
      addr.sin_addr= *(struct in_addr *) he->h_addr;
      printf ("Connecting to %d.%d.%d.%d ...", he->h_addr[0]&0xFF,
        he->h_addr[1]&0xFF, he->h_addr[2]&0xFF, he->h_addr[3]&0xFF);
      fflush (stdout); /* Overwrite this if we are successfull */
      if (connect (serverSock,(struct sockaddr *)&addr, sizeof(addr)) != 0) {
        fprintf (stderr, "%s : %s's %d port\n", strerror(errno), svr,
          portNo);
        exit (5);
      }
      printf("\r                                 \r"); fflush (stdout);
      if (read (serverSock, &myClientNo, sizeof (myClientNo)) !=
      sizeof (myClientNo)) {
        fprintf (stderr, "connect failed\n");
        exit(11);
      }
    }
    else { /* server */
      signal (SIGPIPE, SIG_IGN); /* Keep going when Frans quits */
      listenSock = serverSock; /* use the socket for listening. */
      serverSock = -1;

      addr.sin_addr.s_addr = INADDR_ANY;

      if (bind (listenSock, (struct sockaddr *) &addr, sizeof(addr)) == -1 ||
      listen (listenSock, 1) == -1) {
        perror ("bind / listen");
        exit (3);
      }

    } /* if we serve */
  } /* if a network game */
  
  *downloadSock = serverSock;
  if (serverSock == -1) { /* if we serve others or ourselves */
    msgBuf = (char*)malloc (sizeof (msgBufLen));
    msgBufLen = sizeof (msgBufLen);
    gettimeofday (&lastSynch, &tz);
  }
}

static void AddMsg (int cliNo, void *msg)
{
  int newsize;
  
  newsize = msgBufLen + *(int *)msg + sizeof (cliNo);
  msgBuf = (char *)realloc (msgBuf, newsize);

  *(int *)(msgBuf + msgBufLen) = cliNo;
  memcpy (msgBuf + msgBufLen + sizeof (cliNo), msg, *(int *)msg);
  msgBufLen = newsize;
}

void Broadcast (void *msg)
{
  if (serverSock != -1) { /* if client mode */
    write (serverSock, msg, *(int *)msg);
  }
  else AddMsg (0, msg);
}

void Synchronize (rxMsgHeader **start, rxMsgHeader **stop,
  int (*downloadNew)(int sock, int numberOfNewClient))
/* while it is still dark outside (and the deathmatch continues...) */
{
  struct timeval tv;
  struct timezone tz;
  int msgSize, i, tmp;
  rxMsgHeader *head;
  
  free (oldMsgBuf);
  oldMsgBuf = NULL;

  if (serverSock != -1) { /* if client mode */
    if (read (serverSock, &msgBufLen, sizeof (msgBufLen)) !=
    sizeof (msgBufLen)) {
      fprintf (stderr, "Server closed pipe\n");
      exit (11);
    }
    if (msgBufLen > sizeof (msgBufLen)) {
      oldMsgBuf = (char*)malloc (msgBufLen - sizeof (msgBufLen));
      if (read (serverSock, oldMsgBuf, msgBufLen - sizeof (msgBufLen)) !=
      msgBufLen - sizeof (msgBufLen)) {
        fprintf (stderr, "Server closed pipe\n");
        exit (11);
      }
    }
    *start = (rxMsgHeader*)oldMsgBuf;
    *stop = (rxMsgHeader*)(oldMsgBuf + msgBufLen - sizeof (msgBufLen));
    return;
  }
  
  while (1) { /* while there is still time left till next tick */
    gettimeofday(&tv,&tz);
    lastSynch.tv_usec += SYNCHRONIZER_MS*1000;
    if (lastSynch.tv_usec >= 1000000) {
      lastSynch.tv_usec -= 1000000;
      lastSynch.tv_sec++; /* Calculate the next time */
    }
    if (tv.tv_sec > lastSynch.tv_sec ||
    (tv.tv_sec == lastSynch.tv_sec && tv.tv_usec > lastSynch.tv_usec)) {
      lastSynch.tv_usec = tv.tv_usec; /* What said the mommy tomato to her */
      lastSynch.tv_sec = tv.tv_sec; /* son who has been hit by a car ? */
      break; /* puhctac */
    }
    tv.tv_usec = lastSynch.tv_usec - tv.tv_usec;
    tv.tv_sec = lastSynch.tv_sec - tv.tv_sec;
    if (tv.tv_usec < 0) {
      tv.tv_usec += 1000000;
      tv.tv_sec--;
    }
  
    if (listenSock == -1) {
      usleep (tv.tv_sec * 1000000 + tv.tv_usec);
      break;
    }
    
    fd_set set;
    FD_ZERO(&set);
    FD_SET (listenSock, &set);
    if (select (listenSock + 1, &set, NULL, NULL, &tv) <= 0) break;
    if (FD_ISSET (listenSock, &set)) {
      synchClient = (int*)realloc (synchClient, /* Make space */
        sizeof (*synchClient) * (numClients + 1));
      //printf ("Waiting ... %d", numClients); fflush (stdout);
      struct sockaddr_in incoming;
      tmp = sizeof (incoming);
      if ((synchClient[numClients] = accept (listenSock,
      (struct sockaddr *) &incoming, &tmp)) == -1) {
        perror ("accept");
        exit (8);
      }
      tmp = numClients + 1; /* Tell him his number */
      write (synchClient[numClients], &tmp, sizeof (tmp));
      /* and everything else he needs to know */
      if ((*downloadNew)(synchClient[numClients], tmp)) {
        if (fcntl (synchClient[numClients], F_SETFL, O_NONBLOCK) == -1) {
          perror ("file control");
          exit (8);
        }
        numClients++;
      }
      else close (synchClient[numClients]);
    } /* if someone wants in */
  } /* while waiting for the tick */
  
  if (synchClient != NULL) { /* single player-No need to communicate*/
    for (i = 0; i < numClients; i++) {
      while (synchClient[i] != -1 &&
      (tmp = read (synchClient[i], &msgSize, sizeof (msgSize))) != 0) {
        if (tmp == -1 && errno == EAGAIN) break;
        if (tmp < (int)sizeof (msgSize)) {
          printf ("Incomplete read from %d.\n", i+1);
          //if (tmp == -1) perror("Someone gets scared");
          close (synchClient[i]);
          synchClient[i] = -1;
          continue;
        }
        if (msgSize < sizeof (msgSize) || msgSize > MAX_MSG_SIZE) {
          printf ("Wrong size %x from %d.\n", msgSize, i + 1);
          close (synchClient[i]);
          synchClient[i] = -1;
          continue;
        }
        msgBuf = (char *)realloc (msgBuf,
        msgBufLen + msgSize + sizeof (rxMsgHeader) - sizeof (msgSize));
          
        head = (rxMsgHeader*)(msgBuf + msgBufLen);
        if (msgSize >= sizeof (msgSize) &&
        read (synchClient[i], head + 1,
        msgSize - sizeof (msgSize)) != msgSize - sizeof (msgSize)) {
          printf ("Incomplete read from %d\n", i+1);
          if (tmp == -1) perror("read");
          close (synchClient[i]);
          synchClient[i] = -1;
          continue;
        }
        head->clientNo = i + 1;
        head->len = msgSize;
        msgBufLen += msgSize + sizeof (rxMsgHeader) - sizeof (msgSize);
        //printf("read %d %d\n",msgSize - sizeof (msgSize), msgBufLen);
      } /* while it still has messages. */
    } /* for each client */
    *(int *)msgBuf = msgBufLen;
    for (i = 0; i < numClients; i++) {
      if (synchClient[i] == -1) continue;
      if (write (synchClient[i], msgBuf, msgBufLen) != msgBufLen) {
        printf ("Unable to write to %d\n", i+1);
        close (synchClient[i]);
        synchClient[i] = -1;
      }
    } /* for each client */
  } /* if we serve others */
  oldMsgBuf = msgBuf;
  *start = (rxMsgHeader*)(oldMsgBuf + sizeof (msgBufLen));
  *stop = (rxMsgHeader*)(oldMsgBuf + msgBufLen);
  msgBuf = (char*)malloc (sizeof (msgBufLen));
  msgBufLen = sizeof (msgBufLen);
}

