#ifndef PRIMITIVES_H
#define PRIMITIVES_H

#include <X11/Xlib.h>
#define XK_LATIN1
#define XK_MISCELLANY
#include <X11/keysymdef.h>

#define TEXTURE_WIDTH 256
/* Currently only 8 bit textures with 256 pixels per line are supported. */
/* The largest texture is 256x256 pixels big. */
/* Screen coordinates are resolution independant where (0,0) is upper left */
/* and (2^16,2^16) is lower right */

typedef long long rational;
inline rational mul (rational a, rational b) { return (a*b)>>8; }
inline rational divide (rational a, rational b) { return (a<<8)/b; }
inline int Trunc (rational a) { return a>>8; }
inline rational Rational (int x) { return x<<8; }

typedef struct {
  rational x, y;   /* Resolution independant Screen coordinates */
  rational sx, sy; /* Resolution dependant Screen coordinates */
  rational tx, ty; /* These are in texture space */
} point;
inline operator<(point a, point b)
{
  return a.sy < b.sy || (a.sy == b.sy && a.sx < b.sx);
}

void OpenDisplay (const char *title, int argc, char *argv[]);
void CloseDisplay (void);
void StartFrame (void);

typedef enum { noKeyEvent, keyPressEvent, keyReleaseEvent } keyEventType;
keyEventType GetKey (KeySym *nextKey);
/* Autorepeat will cause unexpected release events (see XAutoRepeatOn) */

extern int screenWidth, screenHeight; /* May change during a resize */
inline void MakeResolutionDependant (point *p, int x, int y)
{
  p->sx = mul (x, screenWidth);
  p->sy = mul (y, screenWidth); /* Don't squash the aspect ratio */
}
#define RES_INDEP_SCREEN_WIDTH  65536
#define RES_INDEP_SCREEN_HEIGHT (RES_INDEP_SCREEN_WIDTH/4*3)

void MapTriangle (unsigned char *source, point *a, point *b, point *c,
  int flags); /* bit 0 : allow transparency */
  
unsigned char *ReadBmpFromFd (int fd);
unsigned char *ReadBmp (const char *fname);

#endif

