#include <stdio.h>

#include "x11_misc.h"



/* ReadXPM - routine Copyright (c) 1995, Alex Brown, used by permission. 
 */
Pixmap ReadXPM(Display *display, Window window, int screen, char *filename,
	       XpmAttributes *return_attributes)
{
  Window root;
  Pixmap rootXpm;
  char real_filename[MAX_PATH_LEN];
  XWindowAttributes root_attr;
  XpmAttributes xpm_attributes;
  int val;

  strcpy(real_filename, filename);
  
  root = RootWindow(display, screen);
  XGetWindowAttributes(display,root,&root_attr); 
  xpm_attributes.colormap = root_attr.colormap;
  xpm_attributes.valuemask = XpmSize | XpmReturnPixels|XpmColormap;
  
  if((val = XpmReadFileToPixmap(display, root, real_filename,
                                &rootXpm, NULL,
			        &xpm_attributes)) != XpmSuccess) {
    if(val == XpmOpenFailed)	
      fprintf(stderr, "Couldn't open pixmap file %s\n", real_filename);
    else if(val == XpmColorFailed)
      fprintf(stderr, "Couldn't allocated required colors\n");
    else if(val == XpmFileInvalid)
      fprintf(stderr, "Invalid Format for an Xpm File\n");
    else if(val == XpmColorError)
      fprintf(stderr, "Invalid Color specified in Xpm FIle\n");
    else if(val == XpmNoMemory)
      fprintf(stderr, "Insufficient Memory\n");
    return -1;
  }

  (*return_attributes) = xpm_attributes;

  return(rootXpm);
}


Pixmap CreateMask(Pixmap pixmap, Display *display, int screen, int width, 
		  int height)
{
  int i, j;
  XImage *image;
  GC gc;
  Pixmap shape = XCreatePixmap(display, RootWindow(display, screen),
			       width, height, 1);

  image = XGetImage(display, pixmap, 0, 0, width, height, AllPlanes, ZPixmap);

  gc = XCreateGC(display, shape, 0, NULL);

  XSetForeground(display, gc, 0);
  XFillRectangle(display, shape, gc, 0, 0, width, height);
  XSetForeground(display, gc, 1);

  for (i = 1; i <=  width; i++)
    for (j = 1; j <= height; j++)
      if (XGetPixel(image, i, j) != BlackPixel(display, screen)) 
        XDrawLine(display, shape, gc, i, j, i, j);

  return (shape);
}


/* Rotate_Pixmap - takes a pixmap and rotates it 90 degrees, order number
 * of times.  Used to create animations of X-Craft.
 */
Pixmap Rotate_Pixmap(Pixmap pixmap, Display *display, Window window,
		     int screen, int width, int height, 
		     XpmAttributes *return_attributes, 
		     char xcraft_colours[3][16], int reset)
{
  int i, j, k;
  XImage *image;
  unsigned long pixel_val;
  GC gc;

  static unsigned long colour_translation[2][3];
  
  Pixmap shape = XCreatePixmap(display, window, height, width, 
			       DefaultDepth(display, screen));
  
  if (reset) {
    memset((void *)&colour_translation[0][0], 0, sizeof(long) * 8);
    
    for (i = 0; i < 3; i++)
      colour_translation[1][i] = palette_colour_set(xcraft_colours[i],
						    display, screen);
  }

  return_attributes->width = height;
  return_attributes->height = width;
  
  image = XGetImage(display, pixmap, 0, 0, width, height, AllPlanes, ZPixmap);
  gc = XCreateGC(display, shape, 0, NULL);
  XSetForeground(display, gc, 0);
  XFillRectangle(display, shape, gc, 0, 0, width, height);
  XSetForeground(display, gc, 1);
  
  for (i = 0; i < width; i++)

    for (j = 0; j < height; j++) {

      pixel_val = XGetPixel(image, i, j);
      
      if (pixel_val != BlackPixel(display, screen)) {
	
	for (k = 0; k < 3; k++) {
	  if (colour_translation[0][k] == (unsigned long)0)
	    colour_translation[0][k] = pixel_val;
	  
	  if (colour_translation[0][k] == pixel_val) {
	    pixel_val = colour_translation[1][k];
	    break;
	  }
	}
      }
      
      XSetForeground(display, gc , pixel_val);

      /* anti-clockwise */
      /*      XDrawLine(display, shape, gc, j, height-i, j, height-i);*/

      /* clockwise */
      XDrawLine(display, shape, gc, width-j, i, width-j, i);
    }
  
  return (shape);
}    


unsigned long palette_colour_set(char *name, Display *display, int screen)
{
  int DefaultDepth;
  Colormap DefaultCMap;
  XColor ExactDef;
  Visual *DefaultVisual;
  
  DefaultDepth = DefaultDepth(display, screen);
  DefaultVisual = DefaultVisual(display, screen);
  DefaultCMap = DefaultColormap(display, screen);

  if (!XParseColor(display, DefaultCMap, name, &ExactDef)) {
    fprintf(stderr,"error: colour not in colour database.\n");
  }
  if (!XAllocColor(display, DefaultCMap, &ExactDef)) {
    fprintf(stderr,"error: can't allocate colour.\n");
  }

  return(ExactDef.pixel);
}
