/* x11.h - X11 output routines for CodeWar
 *
 * Rhett D. Jacobs <rdj@cea.com.au>
 * GNU Public Licence, 1996.
 *
 * Last Modified: <rdj>
 */

#ifndef _X11_H
#define _X11_H

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/xpm.h>

#include "player.h"

typedef struct {
  Display *display;
  int screen;
  Window window;
  Pixmap render_window;
  Sprite server_slow;
  Sprite slow;
  Sprite backdrop_tile;
  Sprite backdrop;
  Sprite cannon, missile, charge, bomb, atomic;
  Sprite explosion[X11_EXPLOSION_MAX];
  GC gc, clear_gc, text_gc;
  GC green_gc, red_gc, blue_gc, orange_gc, cyan_gc, passive_gc, title_gc;
  unsigned long foreground;
  unsigned long background;
  int width;
  int height;
  int channel_refresh;
  short size_change;
  float scale[2];
  XpmAttributes attributes;
} game_window;

typedef struct {
  Window window;
} channel_window;


void X11_refresh(void);
void X11_setup_display(void);
void X11_draw_field_border(void);
void X11_printxy(char *buffer, int x, int y);
void X11_draw_player_positions(void);
void X11_clear_window(int min_x, int min_y, int max_x, int max_y);
void X11_close_display(void);
void X11_draw_player_borders(void);
void X11_draw_box(int min_x, int min_y, int max_x, int max_y);
void X11_field_display(float x, float y, char *buffer);
void X11_refresh_plr(void);
void X11_clear_player_area(void);
void X11_draw_combat(void);
void X11_explode(int id);
void X11_draw_explosions(void);
void X11_field_display_offset(float x, float y, int off_x, int off_y, 
			       char *buffer);

void X11_show_name_sock(Player *plr, int x, int y);
void X11_show_vel_acc(Player *plr, int x, int y);
void X11_show_debug(Player *plr, int x, int y);
void X11_show_can_miss(Player *plr, int x, int y);
void X11_show_bomb_atomic(Player *plr, int x, int y);
void X11_show_head_scan(Player *plr, int x, int y);
void X11_show_damage_shields(Player *plr, int x, int y);
void X11_show_message(Player *plr, int x, int y);
void X11_draw_static_sprite(Player *plr, int x, int y);
void X11_draw_player_status(void);
void X11_draw_static_sprite(Player *plr, int x, int y);
void X11_remove_player(int socket);

#endif
