/* weapon.h - weapon routines for CodeWar
 *
 * Rhett D. Jacobs <rdj@cea.com.au>
 * GNU Public Licence, 1996.
 *
 * Last Modified: 8/3/96 <rdj>
 */

#ifndef _WEAPON_H
#define _WEAPON_H

#include "sim_timers.h"
#include "timers.h"

#define WP_MISSILE     (0)
#define WP_ATOMIC      (1)
#define WP_CANNON      (2)
#define WP_BOMB        (3)
#define WP_CHARGE      (4)


typedef struct _Weapon_List {
  int id;
  short weapon;
  float position[2];
  float velocity[2];
  float acceleration[2];
  /*timer_val detinate;*/
  sim_timer_val detinate;
  struct _Weapon_List *nextptr;
} Weapon_List;


void combat(void);
int weapon_update(Weapon_List *ptr);
int weapon_check_player_bounds(float pos[]);
void weapon_detinate(int id, float x, float y);
int get_unique_id(Weapon_List *search_list);
void add_weapon(short weapon_type, float velocity[2], float position[2],
		float acceleration, float direction, float detinate);
void add_weapon_list(Weapon_List *new, Weapon_List *list);
int find_weapon(int id, Weapon_List **weapon_ptr, Weapon_List *search_list);
int remove_weapon(int id, Weapon_List **search_list);

#endif
