/* timers.h - CodeWar timer routines for "real-time" control
 *
 * Rhett D. Jacobs <rdj@cea.com.au>
 * GNU Public Licence
 *
 * Last Modified: 3/12/95 <rdj>
 */

#ifndef _TIMERS_H
#define _TIMERS_H

#include <sys/time.h>
#include <unistd.h>

typedef struct {
  long tv_sec;
  long tv_usec;
} timer_val;

void set_timer(timer_val *timer, long delay);
int check_timer(timer_val *timer);
long remaining_timer(timer_val *timer);

#endif

