/* timers.c - CodeWar timer routines for "real-time" control
 *
 * Rhett D. Jacobs <rdj@cea.com.au>
 * GNU Public Licence
 *
 * Last Modified: 3/12/95 <rdj>
 */

#include <sys/time.h>
#include <unistd.h>   

#include "timers.h"
#include "misc.h"


/* set_timer - sets the timeout for the passed in time_t variable
 * This value is checked by the check_timer() routine to see if this
 * period of time has passed.
 */
void set_timer(timer_val *timer, long delay)
{
  long val, val2;

  gettimeofday((struct timeval *)timer, (struct timezone *)NULL);
  val = delay/(long)1000000;
  timer->tv_usec += (delay - val * (long)1000000);
  timer->tv_sec += val;
  if (timer->tv_usec >= (long)1000000) {
    val2 = (timer->tv_usec/(long)1000000);
    timer->tv_usec -= (val2 * (long)1000000);
    timer->tv_sec += val2;
  }

  return;
}


/* check_timer - determines if the passed in timer has expired.
 */
int check_timer(timer_val *timer)
{
  timer_val current;
  int ret_val = TRUE;

  gettimeofday((struct timeval *)&current, (struct timezone *)NULL);

  if (current.tv_sec < timer->tv_sec)
    ret_val = FALSE;
  else if (current.tv_sec == timer->tv_sec &&
	   current.tv_usec < timer->tv_usec)
    ret_val = FALSE;
  
  return(ret_val);
}


long remaining_timer(timer_val *timer)
{
  timer_val current;
  long ret_val;

  gettimeofday((struct timeval *)&current, (struct timezone *)NULL);

  ret_val = (timer->tv_sec - current.tv_sec) * (long)1000;
  ret_val += (timer->tv_usec - current.tv_usec) / (long)1000;

  return(ret_val);
}

