/* srv_rqs.c - server request processing
 *
 * Rhett D. Jacobs <rdj@cea.com.au>
 * GNU Public Licence
 *
 * Last Modified: 3/12/95 <rdj>
 */

#include <stdio.h>

#include "srv_rqs.h"
#include "player.h"
#include "cw_server.h"
#include "cw.h"
#include "messages.h"
#include "misc.h"

extern Player *play_list;
extern Config config;
extern Channel channel;


void srv_Send_Acknowledge(int sock)
{
  Mess_Acknowledge Message;

  Message.Message_Type = MT_ACKNOWLEDGE;

  send_message(sock, (unsigned char *)&Message, sizeof(Mess_Acknowledge));

  return;
}


void srv_Get_Status(void *extracted_message, int sock)
{
  Mess_Player_Status Message;
  Player *temp_player;

  Message.Message_Type = MT_PLAYER_STATUS;
      
  find_player(sock, &temp_player, play_list);
  memcpy((void *)&Message.weapons , (void *)&temp_player->weapons, 
	 sizeof(CW_Weapons));
  memcpy((void *)&Message.status , (void *)&temp_player->status, 
	 sizeof(CW_Status));

  send_message(sock, (unsigned char *)&Message,
	       sizeof(Mess_Player_Status));

  return;
}


void srv_Get_Config(void *extracted_message, int sock)
{
  Mess_Config_Status Message;

  Message.Message_Type = MT_CONFIG_STATUS;
  memcpy((void *)&Message.config, (void *)&config, sizeof(Config));

  send_message(sock, (unsigned char *)&Message, sizeof(Mess_Config_Status));

  return;
}


void srv_Get_Channel(void *extracted_message, int sock)
{
  Mess_Channel_Status Message;

  Message.Message_Type = MT_CHANNEL_STATUS;
  memcpy((void *)&Message.channel, (void *)&channel, sizeof(Channel));

  send_message(sock, (unsigned char *)&Message, sizeof(Mess_Channel_Status));

  return;
}
