/* srv_ops.c - server reply processing
 *
 * Rhett D. Jacobs <rdj@cea.com.au>
 * GNU Public Licence
 *
 * Last Modified: 3/12/95 <rdj>
 */

#include <stdio.h>

#include "srv_ops.h"
#include "scan.h"
#include "weapon.h"
#include "player.h"
#include "cw_client.h"
#include "misc.h"

extern Player *play_list;
extern Channel channel;
extern Resource_Defines rd;


void srv_Register_Program(void *extracted_message, int sock)
{
  Mess_Register_Program *Message = (Mess_Register_Program *)extracted_message;
  Player *temp_player;
  
  if (find_player(sock, &temp_player, play_list)) {
    strcpy(temp_player->name, Message->name);
    temp_player->pid = Message->pid;
  }
  
  return;
}


void srv_Print_Buffer(void *extracted_message, int sock)
{
  Player *temp_player;
  Mess_Print_Buffer *Message = (Mess_Print_Buffer *)extracted_message;

  if (find_player(sock, &temp_player, play_list))
    strcpy(temp_player->message, Message->buffer);

  return;
}


void srv_Power(void *extracted_message, int sock)
{
  Mess_Power *message = (Mess_Power *)extracted_message;
  Player *temp_player;

  if (find_player(sock, &temp_player, play_list)) {
    temp_player->status.acc_heading = deg_2_rad(message->direction);
    temp_player->status.acc_desired[X_AXIS]
      = (float)((double)message->acceleration * 
		/* cos_val((float)temp_player->status.acc_heading));*/
		cos((double)temp_player->status.acc_heading));
    temp_player->status.acc_desired[Y_AXIS]
      = (float)((double)message->acceleration * 
		/* sin_val((float)temp_player->status.acc_heading));*/
		sin((double)temp_player->status.acc_heading));
  }

  return;
}


void srv_Scan(void *extracted_message, int sock)
{
  Mess_Scan *message = (Mess_Scan *)extracted_message;
  Player *temp_player;
  
  if (find_player(sock, &temp_player, play_list)) {
    temp_player->status.scan_dir = deg_2_rad(message->direction);
    temp_player->status.scan = 
      scan(temp_player->socket, temp_player->status.scan_dir,
	   deg_2_rad(message->range));
  }

  return;
}


void srv_Missile(void *extracted_message, int sock)
{
  Mess_Missile *message = (Mess_Missile *)extracted_message;
  Player *temp_player;

  if (find_player(sock, &temp_player, play_list)) {
    if (temp_player->weapons.missiles > 0) {
      temp_player->weapons.missiles--;
      add_weapon(WP_MISSILE, 
		 temp_player->status.velocity, 
		 temp_player->status.position,
		 message->acceleration, deg_2_rad(message->direction), 
		 message->detinate);
    }
  }
  return;
}


void srv_Charge(void *extracted_message, int sock)
{
  Mess_Charge *message = (Mess_Charge *)extracted_message;
  Player *temp_player;

  if (find_player(sock, &temp_player, play_list)) {
    add_weapon(WP_CHARGE, 
	       temp_player->status.velocity, 
	       temp_player->status.position,
	       message->acceleration, deg_2_rad(message->direction), 
	       message->detinate);
  }
  return;
}


void srv_Atomic(void *extracted_message, int sock)
{
  Mess_Atomic *message = (Mess_Atomic *)extracted_message;
  Player *temp_player;

  if (find_player(sock, &temp_player, play_list)) {
    if (temp_player->weapons.atomics > 0) {
      temp_player->weapons.atomics--;
      add_weapon(WP_ATOMIC,
		 temp_player->status.velocity, 
		 temp_player->status.position,
		 message->acceleration, deg_2_rad(message->direction), 
		 message->detinate);
    }
  }
  return;
}


void srv_Cannon(void *extracted_message, int sock)
{
  Mess_Cannon *message = (Mess_Cannon *)extracted_message;
  Player *temp_player;
  float velocity[2];
  float rad_dir;

  if (find_player(sock, &temp_player, play_list)) {
    if (temp_player->weapons.cannons > (long)0) {
      temp_player->weapons.cannons--;
      rad_dir = deg_2_rad(message->direction);
      velocity[X_AXIS] = temp_player->status.velocity[X_AXIS];
      velocity[Y_AXIS] = temp_player->status.velocity[Y_AXIS];
      
      velocity[X_AXIS] += 
	(message->velocity * 
	 /*(float)cos_val((float)rad_dir));*/
	 (float)cos((double)rad_dir));
      velocity[Y_AXIS] += 
	(message->velocity *
	 /*(float)sin_val((float)rad_dir));*/
	 (float)sin((double)rad_dir));
      
      add_weapon(WP_CANNON, velocity, 
		 temp_player->status.position,
		 0.0, rad_dir, message->detinate);
    }
  }
  return;
}


void srv_Bomb(void *extracted_message, int sock)
{
  Mess_Bomb *message = (Mess_Bomb *)extracted_message;
  Player *temp_player;

  if (find_player(sock, &temp_player, play_list)) {
    if (temp_player->weapons.bombs > 0) {
      temp_player->weapons.bombs--;
      add_weapon(WP_BOMB,
		 temp_player->status.velocity,
		 temp_player->status.position,
		 0.0, 0.0, message->detinate);
    }
  }
  return;
}


void srv_Boost_Shields(void *extracted_message, int sock)
{
  Mess_Boost_Shields *message = (Mess_Boost_Shields *)extracted_message;
  Player *temp_player;

  if (find_player(sock, &temp_player, play_list)) {
    if (temp_player->status.energy < message->energy)
      message->energy = temp_player->status.energy;

    temp_player->status.shields += message->energy;
    temp_player->status.energy -= message->energy;

    if (temp_player->status.shields > 100)
      temp_player->status.shields = 100;
  }
  return;
}


void srv_Tx_Channel(void *extracted_message, int sock)
{
  Mess_Tx_Channel *message = (Mess_Tx_Channel *)extracted_message;

  if (message->channel >= 0 && message->channel < rd.channel_bandwidth)
    channel.data[message->channel] = message->data;

  return;
}
