/* sim_timers.h - CodeWar timer routines for "real-time" control
 *
 * Rhett D. Jacobs <rdj@cea.com.au>
 * GNU Public Licence
 *
 * Last Modified: 3/12/95 <rdj>
 */


#include "sim_timers.h"
#include "misc.h"

extern Config config;

void set_sim_timer(sim_timer_val *timer, long delay)
{
  timer->expire = config.elapsed_time + (float)delay/1000000.0;
}


int check_sim_timer(sim_timer_val *timer)
{
  int ret_val = FALSE;

  if (timer->expire < config.elapsed_time)
    ret_val = TRUE;

  return(ret_val);
}


long remaining_sim_timer(sim_timer_val *timer)
{
  return((long)(timer->expire - config.elapsed_time));
}
