/* server.h - networking routines for CodeWar server
 *
 * Rhett D. Jacobs <rdj@cea.com.au>
 * GNU Public Licence
 *
 * Last Modified: 3/12/95 <rdj>
 */

#ifndef _SERVER_H
#define _SERVER_H

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>

#define SERVER_SEC 1
#define SERVER_USEC 0

int cw_server_init(void);
int cw_server_process(void);
void cw_server_close(int sig);
void cw_set_server_flags(void);
void cw_server_init_periodics(void);
void cw_signal_handler(int sig);
void cw_server_periodics(void);
void service_msg_queues(void);
void append_port_buff(unsigned char *port_buff, int *port_buff_size,
		      unsigned char *append_buff, int append_buff_size);

#endif
