/* scan.c - CodeWar scan routines for player detection.
 *
 * Last Modified: 16/1/96 <rdj>
 */

#include "scan.h"
#include "misc.h"
#include "player.h"

extern Player *play_list;
extern Config config;

/* scan - performs a check for other X-Craft within the angle and range
 * specified.  Returns the distance to target.
 */
float scan(int socket, float angle, float range)
{
  Player *plr, *check_plr;
  float plr_angle, distance, ret_val = -1.0;
  float delta_y, delta_x;

  if (find_player(socket, &plr, play_list)) {
    if (play_list != NULL) {
      check_plr = play_list;
      while (check_plr != NULL) {
	if (check_plr->socket != socket) {
	  delta_y = (float)(check_plr->status.position[Y_AXIS] -
			    plr->status.position[Y_AXIS]);
	  delta_x = (float)(check_plr->status.position[X_AXIS] -
			    plr->status.position[X_AXIS]);
	  if (delta_y != 0.0 && delta_x != 0.0) {
	    plr_angle = (float)atan2((double)delta_y, (double)delta_x);
	    if (circ_comp(angle, plr_angle, range, TWO_PI)) {
	      distance = pythagoras(delta_x, delta_y);
	      if (ret_val == -1.0)
		ret_val = distance;
	      else
		if (distance < ret_val)
		  ret_val = distance;
	    }
	  }
	}
	check_plr = check_plr->nextplr;
      }
    }
  }
  
  return(ret_val);
}


int circ_comp(float val_1, float val_2, float error, float repeat)
{
  int ret_val = FALSE;
  float comp_1, comp_2;
  int val_modify[2][2] = {{FALSE, FALSE}, {FALSE, FALSE}};

  while (val_1 < 0.0)
    val_1 += repeat;
  while (val_2 < 0.0)
    val_2 += repeat;
  while (val_1 >= repeat)
    val_1 -= repeat;
  while (val_2 >= repeat)
    val_1 -= repeat;
  
  if (val_1 + error >= repeat)
    val_modify[0][1] = TRUE;
  if (val_1 - error < 0.0)
    val_modify[0][0] = TRUE;
  if (val_2 + error >= repeat)
    val_modify[1][1] = TRUE;
  if (val_2 - error < 0.0)
    val_modify[1][0] = TRUE;
  
  comp_1 = val_1;
  comp_2 = val_2;

  if (val_modify[0][0] && val_modify[1][1]) {
    comp_1 = val_1 + repeat;
    comp_2 = val_2;
  }
  if (val_modify[0][1] && val_modify[1][0]) {
    comp_1 = val_1;
    comp_2 = val_2 + repeat;
  }
  if ((comp_1 > comp_2 - error) && (comp_1 < comp_2 + error))
    ret_val = TRUE;

  return(ret_val);
}
