/* resource.c - CodeWar resource handler
 *
 * Rhett D. Jacobs <rdj@cea.com.au>
 * GNU Public Licence, 1996.
 *
 * Last Modified: <rdj>
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/param.h>
#include <X11/Xlib.h>
#include <X11/Xresource.h>

#include "misc.h"
#include "resource.h"

#define NUM_FILE_LOCATIONS (6)

extern Resource_Defines rd;

static XrmDatabase cw_resources;
static char *home_dir = (char *)NULL;


int resource_string(char *str_name, char *str_class, char *value)
{
  int ret_val;
  char *string_type[20];
  XrmValue DBvalue;
  
  ret_val = XrmGetResource(cw_resources, str_name, str_class, 
			   string_type, &DBvalue);
  strncpy(value, DBvalue.addr, (int)DBvalue.size);

  return(ret_val);
}


void resource_get_strings(void)
{
  char *str_ptr;
  char path_string[255];
  char temp_string[255];
  
  if (resource_string("codewar.pixmaps_dir", NULL, temp_string)) {
    if ((str_ptr = strstr(temp_string, "~")) != NULL) {
      strcpy(path_string, str_ptr+1);
      sprintf(rd.x11_pixmap_path, "%s%s", home_dir, path_string);
    } else 
      strcpy(rd.x11_pixmap_path, temp_string);
  }
  
  if (resource_string("codewar.boundary_type", NULL, temp_string)) {
    if (!(strncmp(temp_string, "RUBBER", strlen("RUBBER"))))
      rd.wall_type = 0;
    else if (!(strncmp(temp_string, "STONE", strlen("STONE"))))
      rd.wall_type = 1;
    else if (!(strncmp(temp_string, "ABYSS", strlen("ABYSS"))))
      rd.wall_type = 2;
    else if (!(strncmp(temp_string, "TWIGHLIGHT", strlen("TWIGHLIGHT"))))
      rd.wall_type = 3;
  }

  if (resource_string("codewar.pixmaps_xcraft", NULL, temp_string))
    strcpy(rd.x11_xcraft, temp_string);

  if (resource_string("codewar.pixmaps_backdrop", NULL, temp_string))
    strcpy(rd.x11_backdrop, temp_string);

  if (resource_string("codewar.pixmaps_icon", NULL, temp_string))
    strcpy(rd.x11_icon, temp_string);

  if (resource_string("codewar.pixmaps_cannon", NULL, temp_string))
    strcpy(rd.x11_cannon, temp_string);

  if (resource_string("codewar.pixmaps_missile", NULL, temp_string))
    strcpy(rd.x11_missile, temp_string);

  if (resource_string("codewar.pixmaps_charge", NULL, temp_string))
    strcpy(rd.x11_charge, temp_string);

  if (resource_string("codewar.pixmaps_bomb", NULL, temp_string))
    strcpy(rd.x11_bomb, temp_string);

  if (resource_string("codewar.pixmaps_atomic", NULL, temp_string))
    strcpy(rd.x11_atomic, temp_string);

  if (resource_string("codewar.pixmaps_anim_explosion", NULL, temp_string))
    strcpy(rd.x11_anim_explosion, temp_string);

  if (resource_string("codewar.pixmaps_x11_slow", NULL, temp_string))
    strcpy(rd.x11_slow, temp_string);

  if (resource_string("codewar.pixmaps_x11_server_slow", NULL, temp_string))
    strcpy(rd.x11_server_slow, temp_string);
}
 

void resource_get_floats(void)
{
  char temp_string[255];
  
  if (resource_string("codewar.battlefield_width", NULL, temp_string))
    rd.cw_battle_x = atof(temp_string);

  if (resource_string("codewar.battlefield_height", NULL, temp_string))
    rd.cw_battle_y = atof(temp_string);
}


void resource_get_longs(void)
{
  char temp_string[255];
  
  if (resource_string("codewar.screen_update", NULL, temp_string))
    rd.screen_update = atol(temp_string);

  if (resource_string("codewar.simulate_interval", NULL, temp_string))
    rd.simulate_interval = atol(temp_string);

  if (resource_string("codewar.screen_update", NULL, temp_string))
    rd.screen_update = atol(temp_string);
}


void resource_get_ints(void)
{
  char temp_string[255];
  
  if (resource_string("codewar.xcraft_force", NULL, temp_string))
    rd.xcraft_force = atoi(temp_string);

  if (resource_string("codewar.xcraft_mass", NULL, temp_string))
    rd.dft_status_mass = atoi(temp_string);

  if (resource_string("codewar.x11_server_width", NULL, temp_string))
    rd.gfx_width = atoi(temp_string);

  if (resource_string("codewar.x11_server_height", NULL, temp_string))
    rd.gfx_height = atoi(temp_string);

  if (resource_string("codewar.channel_bandwidth", NULL, temp_string))
    rd.channel_bandwidth = atoi(temp_string);

  if (resource_string("codewar.xcraft_weapons_cannons", NULL, temp_string))
    rd.dft_weapons_cannons = atoi(temp_string);

  if (resource_string("codewar.xcraft_weapons_missiles", NULL, temp_string))
    rd.dft_weapons_missiles = atoi(temp_string);

  if (resource_string("codewar.xcraft_weapons_atomics", NULL, temp_string))
    rd.dft_weapons_atomics = atoi(temp_string);

  if (resource_string("codewar.xcraft_status_damage", NULL, temp_string))
    rd.dft_status_damage = atoi(temp_string);

  if (resource_string("codewar.xcraft_status_shields", NULL, temp_string))
    rd.dft_status_shields = atoi(temp_string);

  if (resource_string("codewar.xcraft_status_energy", NULL, temp_string))
    rd.dft_status_energy = atoi(temp_string);

  if (resource_string("codewar.xcraft_damage_max", NULL, temp_string))
    rd.damage_max = atoi(temp_string);

  if (resource_string("codewar.x11_xcraft_win_width", NULL, temp_string))
    rd.x11_xcraft_win_width = atoi(temp_string);

  if (resource_string("codewar.x11_xcraft_win_height", NULL, temp_string))
    rd.x11_xcraft_win_height = atoi(temp_string);

  if (resource_string("codewar.x11_channel_win_width", NULL, temp_string))
    rd.x11_channel_win_width = atoi(temp_string);

  if (resource_string("codewar.x11_channel_win_height", NULL, temp_string))
    rd.x11_channel_win_height = atoi(temp_string);
}


int codewar_resources(void)
{
  int i, ret_val = 0, found = 0;
  char file_locations[NUM_FILE_LOCATIONS][255] = {
    "./codewarrc",
    "./.codewarrc",
    "/usr/X11/lib/X11/app-defaults/codewarrc", 
    "/usr/X11/lib/X11/app-defaults/.codewarrc"
  };

  home_dir = getenv("HOME");
  sprintf(file_locations[4],"%s/.codewarrc", home_dir);
  sprintf(file_locations[5],"%s/codewarrc", home_dir);

  XrmInitialize();
  
  for (i = 0; i < NUM_FILE_LOCATIONS; i++) {
    if ((cw_resources = XrmGetFileDatabase(file_locations[i])) != NULL) {
      found = 1;
      break;
    }
  }
  
  if (found) {
    resource_get_strings();
    resource_get_floats();
    resource_get_longs();
    resource_get_ints();

    ret_val = 1;
  } else
    fprintf(stderr,"warning: no resource file, using defaults.\n");   
  
  return(ret_val);
}
