/* player.h - Player detail manipulation routines
 *
 * Rhett D. Jacobs <rdj@cea.com.au>
 * GNU Public Licence
 *
 * Last Modified: 3/12/95 <rdj>
 */

#ifndef _PLAYER_H
#define _PLAYER_H

#include <unistd.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/xpm.h>

#include "config.h"
#include "timers.h"

#define X_AXIS                  (0)
#define Y_AXIS                  (1)

typedef struct _Sprite {
  Pixmap image;
  Pixmap mask;
  XpmAttributes attributes;
} Sprite;

typedef struct _CW_Weapons {
  int missiles;
  int atomics;
  long cannons;
  int bombs;
} CW_Weapons;

typedef struct _CW_Status {
  int damage;
  int shields;
  int mass;
  int energy;
  float position[2];
  float velocity[2];
  float acc_desired[2];
  float acc_actual[2];
  float acc_heading;
  float scan;
  float scan_dir;
} CW_Status;

typedef struct _CW_Graphics {
  short first;
  Sprite xcraft[X11_XCRAFT_MAX];
  timer_val frame_timer;
  long frame_delay;
  int current_frame;
  char xcraft_colour[3][16];
  Window window;
} CW_Graphics;

typedef struct _Player {
  int socket;
  pid_t pid;
  unsigned char port_buffer[MAX_PORT_BUFF];
  int port_buffer_size;
  char name[128];
  char message[255];
  CW_Weapons weapons;
  CW_Status status;
  CW_Graphics graphics;
  struct _Player *nextplr;
} Player;

int add_player(char *name, int socket);
void add_plr_list(Player *plr, Player *list);
int find_player(int socket, Player **player_ptr, Player *search_list);
int remove_player(int socket, Player **search_list);

#endif
