/* player.c - Player detail manipulation routines
 *
 * Rhett D. Jacobs <rdj@cea.com.au>
 * GNU Public Licence
 *
 * Last Modified: 3/12/95 <rdj>
 */

#include "player.h"
#include "graphics.h"
#include "misc.h"

extern Config config;
extern Resource_Defines rd;

Player *play_list = (Player *)NULL;
int colour_index = 0;

const char xcraft_colour_list[NUM_XCRAFT_COLOURS][3][16] = {
  {{"grey30"}, {"grey60"}, {"grey90"}},
  {{"yellow"}, {"grey80"}, {"darkblue"}},
  {{"red"}, {"grey20"}, {"blue"}},
  {{"cyan"}, {"grey60"}, {"darkgreen"}}
};


int add_player(char *name, int socket) 
{
  int i, ret_val = TRUE;
  Player *new_player;
  static Player default_player;
  static int first = 1;
  
  if (first) {
    default_player.message[0] = (char) NULL;
    default_player.graphics.first = 1;
    default_player.graphics.frame_delay = rd.dft_anim_delay;
    default_player.weapons.missiles = rd.dft_weapons_missiles;
    default_player.weapons.atomics = rd.dft_weapons_atomics;
    default_player.weapons.cannons = rd.dft_weapons_cannons;
    default_player.weapons.bombs = rd.dft_weapons_bombs;
    
    default_player.status.damage = rd.dft_status_damage;
    default_player.status.shields = rd.dft_status_shields;
    default_player.status.energy = rd.dft_status_energy;
    default_player.status.velocity[X_AXIS] =
      default_player.status.velocity[Y_AXIS] = rd.dft_status_velocity;
    default_player.status.acc_heading = rd.dft_status_heading;
    default_player.status.acc_desired[X_AXIS] = 
      default_player.status.acc_desired[Y_AXIS] =
      default_player.status.acc_actual[X_AXIS] =
      default_player.status.acc_actual[Y_AXIS] =
      rd.dft_status_acceleration;
    default_player.status.scan = rd.dft_status_scan;
    default_player.status.scan_dir = rd.dft_status_scan_dir;
    default_player.status.mass = rd.dft_status_mass;
    default_player.port_buffer_size = 0;
      
    first = 0;
  }
  
  if ((new_player = (Player *)malloc((size_t)sizeof(Player))) != NULL) {
    memcpy((void *)new_player, (void *)&default_player, sizeof(Player));
    
    /* use of random function makes it not suitable for memcpy() */
    new_player->status.position[X_AXIS] = DFT_STATUS_POSITION_X;
    new_player->status.position[Y_AXIS] = DFT_STATUS_POSITION_Y;
    
    strcpy(new_player->name, name);
    new_player->socket = socket;
    
    for (i = 0; i < 3; i++)
      strcpy(new_player->graphics.xcraft_colour[i],
	     xcraft_colour_list[colour_index%NUM_XCRAFT_COLOURS][i]);
    colour_index++;
    
    add_plr_list(new_player, play_list);
  } else {
    fprintf(stderr,"error: could not malloc memory for additional X-Craft\n");
    ret_val = FALSE;
  }
  
  return(ret_val);
}


void add_plr_list(Player *plr, Player *list)
{
  Player *tmp;

  if (list == NULL)
    play_list = plr;
  else {
    tmp = list;
    while (tmp->nextplr != NULL)
      tmp = tmp->nextplr;
    tmp->nextplr = plr;
  }
  return;
}


/* find_player - finds a player. 
 */
int find_player(int socket, Player **player_ptr, Player *search_list)
{
  Player *tmp;

  if (search_list == NULL)
    return(FALSE);
  else {
    tmp = search_list;
    while (tmp != NULL) {
      if (tmp->socket == socket) {
	*player_ptr = tmp;
	return(TRUE);
      }
      tmp = tmp->nextplr;
    }
  }
  return(FALSE);
}


/* remove_player - Removes a player.
 */
int remove_player(int socket, Player **search_list)
{
  Player *tmp, *tmp2;

  graphics_remove_player(socket);
  graphics_refresh_plr();

  if (*search_list == NULL)
    return(FALSE);
  else {
    tmp = *search_list;
    if (tmp->socket == socket) {
      if (close(tmp->socket) == -1)
	fprintf(stderr,"error: could not close socket.\n");
      /*kill(tmp->pid, SIGKILL);*/
      if (tmp->nextplr == NULL) {
	*search_list = NULL;
	free(tmp);
      } else {
	*search_list = tmp->nextplr;
	free(tmp);
      }
    } else {
      tmp2 = tmp;
      tmp = tmp->nextplr;
      while (tmp != NULL) {
	if (tmp->socket == socket) {
	  if (close(tmp->socket) == -1)
	    fprintf(stderr,"error: could not close socket.\n");
	  /*kill(tmp->pid, SIGKILL);*/
	  tmp2->nextplr = tmp->nextplr;
	  free(tmp);
	  return(TRUE);
	} else {
	  tmp2 = tmp;
	  tmp = tmp->nextplr;
	}
      }
    }
  }

  return(FALSE);
}
