/* misc.h - Miscellaneous CodeWar function calls
 *
 * Rhett D. Jacobs <rdj@cea.com.au>
 * GNU Public Licence
 *
 * Last Modified: 3/12/95 <rdj>
 */

#ifndef _MISC_H
#define _MISC_H

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <math.h>

#include "config.h"

#ifndef FALSE 
#define FALSE (0)
#endif

#ifndef TRUE
#define TRUE (!(FALSE))
#endif

#define TWO_PI                    ((double)2.0 * M_PI)
#define deg_2_rad(X)              ((double)X*(double)M_PI/(double)180.0)
#define rad_2_deg(X)              ((double)X*(double)180.0/(double)M_PI)
#define pythagoras(X,Y)           sqrt((X)*(X)+(Y)*(Y))

enum wall_types{RUBBER, STONE, ABYSS, TWIGHLIGHT};

typedef struct {
  long screen_update;
  long simulate_int;
  float time_int;
  int xcraft_force;
  float field[2];
  int wall_type;
  int graphics_mode;
  int server_slow;
  float elapsed_time;
} Config;

typedef struct {
  int bandwidth;
  unsigned char *data;
} Channel;


typedef struct {
  float version;
  long screen_update;
  long simulate_interval;
  float time_int;
  int xcraft_force;
  float cw_battle_x;
  float cw_battle_y;
  int gfx_width;
  int gfx_height;
  int wall_type;
  int channel_bandwidth;
  int dft_weapons_missiles;
  int dft_weapons_atomics;
  int dft_weapons_cannons;
  int dft_weapons_bombs;
  int dft_status_damage;
  int dft_status_shields;
  int dft_status_energy;
  int dft_status_velocity;
  int dft_status_heading;
  int dft_status_acceleration;
  int dft_status_scan;
  int dft_status_scan_dir;
  int dft_status_mass;
  int damage_max;
  int x11_xcraft_win_width;
  int x11_xcraft_win_height;
  int x11_channel_win_width;
  int x11_channel_win_height;
  char x11_pixmap_path[255];
  char x11_backdrop[32];
  char x11_icon[32];
  char x11_xcraft[32];
  char x11_cannon[32];
  char x11_missile[32];
  char x11_charge[32];
  char x11_bomb[32];
  char x11_atomic[32];
  char x11_anim_explosion[32];
  char x11_slow[32];
  char x11_server_slow[32];
  long dft_anim_delay;
} Resource_Defines;

void set_config_defaults(void);
void set_defaults(void);
void error_print(char *message, int exit_flag, int exit_value);
void debug_print(unsigned char *buffer, int buf_size);

#endif
