/* misc.c - Miscellaneous CodeWar function calls
 *
 * Rhett D. Jacobs <rdj@cea.com.au>
 * GNU Public Licence, 1996.
 *
 * Last Modified: <rdj>
 */

#include <stdio.h>
#include <string.h>

#include "misc.h"
#include "player.h"
#include "config.h"

extern Player *play_list;
Config config;
Channel channel;
Resource_Defines rd;


void set_config_defaults(void)
{
  memset((void *)&rd, 0, sizeof(Resource_Defines));

  rd.version = VERSION;
  rd.screen_update = SCREEN_UPDATE;
  rd.simulate_interval = SIMULATE_INTERVAL;
  rd.time_int = TIME_INT;
  rd.cw_battle_x = CW_BATTLE_X;
  rd.cw_battle_y = CW_BATTLE_Y;
  rd.gfx_width = GFX_WIDTH;
  rd.gfx_height = GFX_HEIGHT;
  rd.wall_type = WALL_TYPE;
  rd.channel_bandwidth = CHANNEL_BANDWIDTH;
  rd.dft_weapons_missiles = DFT_WEAPONS_MISSILES;
  rd.dft_weapons_atomics = DFT_WEAPONS_ATOMICS;
  rd.dft_weapons_cannons = DFT_WEAPONS_CANNONS;
  rd.dft_weapons_bombs = DFT_WEAPONS_BOMBS;
  rd.dft_status_damage = DFT_STATUS_DAMAGE;
  rd.dft_status_shields = DFT_STATUS_SHIELDS;
  rd.dft_status_energy = DFT_STATUS_ENERGY;
  rd.dft_status_velocity = DFT_STATUS_VELOCITY;
  rd.dft_status_heading = DFT_STATUS_HEADING;
  rd.dft_status_acceleration = DFT_STATUS_ACCELERATION;
  rd.dft_status_scan = DFT_STATUS_SCAN;
  rd.dft_status_scan_dir = DFT_STATUS_SCAN_DIR;
  rd.dft_status_mass = DFT_STATUS_MASS;
  rd.damage_max = DAMAGE_MAX;
  rd.x11_xcraft_win_width = X11_XCRAFT_WIN_WIDTH;
  rd.x11_xcraft_win_height = X11_XCRAFT_WIN_HEIGHT;
  rd.x11_channel_win_width = X11_CHANNEL_WIN_WIDTH;
  rd.x11_channel_win_height = X11_CHANNEL_WIN_HEIGHT;
  strcpy(rd.x11_pixmap_path, X11_PIXMAP_PATH);
  strcpy(rd.x11_backdrop, X11_BACKDROP);
  strcpy(rd.x11_icon, X11_ICON);
  strcpy(rd.x11_xcraft, X11_XCRAFT);
  strcpy(rd.x11_cannon, X11_CANNON);
  strcpy(rd.x11_missile, X11_MISSILE);
  strcpy(rd.x11_charge, X11_CHARGE);
  strcpy(rd.x11_bomb, X11_BOMB);
  strcpy(rd.x11_atomic, X11_ATOMIC);
  strcpy(rd.x11_anim_explosion, X11_ANIM_EXPLOSION);
  strcpy(rd.x11_slow, X11_SLOW);
  strcpy(rd.x11_server_slow, X11_SERVER_SLOW);
  rd.dft_anim_delay = DFT_ANIM_DELAY;
}


/* set_defaults - sets default global config's as based upon settings
 * in the config.h file.
 */
void set_defaults(void)
{
  memset((void *)&config, 0, sizeof(Config));
  memset((void *)&channel, 0, sizeof(Channel));

  channel.bandwidth = rd.channel_bandwidth;

  config.screen_update = rd.screen_update;
  config.simulate_int = rd.simulate_interval;
  config.time_int = rd.time_int;
  config.xcraft_force = rd.xcraft_force;
  config.field[X_AXIS] = rd.cw_battle_x;
  config.field[Y_AXIS] = rd.cw_battle_y;
  config.wall_type = rd.wall_type;

  if ((channel.data =
       (unsigned char *)calloc(rd.channel_bandwidth,
			       sizeof(unsigned char))) == NULL) {
    fprintf(stderr,"error: could not allocate memory for open channel.\n");
    exit(1);
  }

  return;
}

/* error_print - general error output handling function.
 */
void error_print(char *message, int exit_flag, int exit_value)
{
  fprintf(stderr,"error: %s.\n", message);

  if (exit_flag)
    exit(exit_value);
  
  return;
}


/* debug_print - raw hex output of passed in buffer
 */
void debug_print(unsigned char *buffer, int buf_size)
{
  int i, row_count = -1, col_count = -1;
  
  for (i = 0; i < buf_size; i++) {
    if (!((++row_count)%4)) {
      printf(" ");
      if(!((++col_count)%3))
	printf("\n");
    }
    if (buffer[i] < 16)
      printf("0%X", buffer[i]);
    else
      printf("%X", buffer[i]);
  }
  printf("\n");

  return;
}
