/* messages.h - routines to handle TCP/IP message parsing/passing.
 *
 * Rhett D. Jacobs <rdj@cea.com.au>
 * GNU Public Licence.
 *
 * Last Modified: 29/12/95 <rdj>
 */

#ifndef _MESSAGES_H
#define _MESSAGES_H

#define MAX_BUF_SIZE (512)

typedef struct {
  int max_port_size;
  int msg_errors;
  int port_errors;
} msg_statistics;

int send_message(int sock, unsigned char *data_type, int data_size);

int process_message(int sock, unsigned char *buffer, int buf_size);
int get_message_size(int current_message);
void process_request(int current_message, void *extracted_message, int sock);
int shift_down(unsigned char *destination, int num_characters, 
	       int total_length);
int extract_message(unsigned char *buffer, int *buf_size,
		    unsigned char *dest_buffer, int extract_size);
int process_message_buffer(int sock, unsigned char *buffer, int *buf_size);

#endif





