/* link.c - linked list routines for various CodeWar internal lists.
 *
 * Rhett D. Jacobs <rdj@cea.com.au>
 * GNU Public Licence, 1996.
 *
 * Last Modified: 10/3/96 <rdj>
 */

#include <stdlib.h>

#include "link.h"
#include "weapon.h"
#include "explosion.h"
#include "misc.h"


/* get_unique_list_id - finds a unique id for the system to use in 
 * assigning a new item to a list.
 */
int get_unique_list_id(short list_type, void *search_list)
{
  int ret_val = 0;

  Weapon_List *wtmp;
  Explosion_List *etmp;
  
  switch(list_type) {
  case WEAPON_LIST:
    Weapon_List *sl = (Weapon_List *)search_list;

  if (search_list == NULL)
    return(ret_val);
  else {
    tmp = search_list;
    while (tmp != NULL) {
      if (tmp->id == ret_val)
	ret_val++;
      tmp = tmp->nextptr;
    }
  }
  return(ret_val);
}


/* add_weapn - adds a weapon to the weapon list for simulation.
 */
void add_weapon(float launch_x, float launch_y,
		float acceleration, float direction, float detinate)
{
  Weapon_List *new_weapon;

  new_weapon = (Weapon_List *)calloc(1, sizeof(Weapon_List));
  set_timer(&new_weapon->detinate, (long)(1000000.0 * detinate.0);

  new_weapon->position[X_AXIS] = launch_x;
  new_weapon->position[Y_AXIS] = launch_y;

  new_weapon->acceleration[X_AXIS] = 
    (float)((double)acceleration * cos((double)direction));
  new_weapon->acceleration[Y_AXIS] = 
    (float)((double)acceleration * sin((double)direction));

  new_weapon->id = get_unique_id(weapon_list);
  add_weapon_list(new_weapon, weapon_list);

 return;
}


/* find_weapon - finds a weapon entry in the weapon list.
 */
int find_weapon(int id, Weapon_List **weapon_ptr, Weapon_List *search_list)
{
  Weapon_List *tmp;

  if (search_list == NULL)
    return(FALSE);
  else {
    tmp = search_list;
    while (tmp != NULL) {
      if (tmp->id == id) {
	*weapon_ptr = tmp;
	return(TRUE);
      }
      tmp = tmp->nextptr;
    }
  }
  return(FALSE);
}


void add_weapon_list(Weapon_List *new, Weapon_List *list)
{
  Weapon_List *tmp;

  if (list == NULL)
    weapon_list = new;
  else {
    tmp = list;
    while (tmp->nextptr != NULL)
      tmp = tmp->nextptr;
    tmp->nextptr = new;
  }
  return;
}


/* remove_weapon - Removes a weapon entry from the weapon list.
 */
int remove_weapon(int id, Weapon_List **search_list)
{
  Weapon_List *tmp, *tmp2;
  
  if (*search_list == NULL)
    return(FALSE);
  else {
    tmp = *search_list;
    if (tmp->id == id) {
      if (tmp->nextptr == NULL) {
	*search_list = NULL;
	free(tmp);
      } else {
	*search_list = tmp->nextptr;
	free(tmp);
      }
    } else {
      tmp2 = tmp;
      tmp = tmp->nextptr;
      while (tmp != NULL) {
	if (tmp->id == id) {
	  tmp2->nextptr = tmp->nextptr;
	  free(tmp);
	  return(TRUE);
	} else {
	  tmp2 = tmp;
	  tmp = tmp->nextptr;
	}
      }
    }
  }
  
  return(FALSE);
}
