/* graphics.h - generic graphics routines and jumptable setup
 *
 * Rhett D. Jacobs <rdj@cea.com.au>
 * GNU Public Licence, 1996.
 *
 * Last Modified: 6/6/1996 <rdj>
 */


#ifndef _GRAPHICS_H
#define _GRAPHICS_H

#include "player.h"
#include "misc.h"

enum graphics_modes{CURSES, NCURSES, XLIB};

extern void (*graphics_refresh)(void);
extern void (*graphics_setup_display)(void);
extern void (*graphics_draw_field_border)(void);
extern void (*graphics_printxy)(char *, int, int);
extern void (*graphics_draw_player_positions)(void);
extern void (*graphics_clear_window)(int, int, int, int);
extern void (*graphics_close_display)(void);
extern void (*graphics_draw_player_borders)(void);
extern void (*graphics_draw_box)(int, int, int, int);
extern void (*graphics_field_display)(float, float, char *);
extern void (*graphics_refresh_plr)(void);
extern void (*graphics_clear_player_area)(void);
extern void (*graphics_draw_combat)(void);
extern void (*graphics_explode)(int);
extern void (*graphics_draw_explosions)(void);
extern void (*graphics_field_display_offset)(float, float, int, int, char *);
extern void (*graphics_remove_player)(int);

void set_graphics(int graphics_mode);

#endif
