/* graphics.c - generic graphics routines and pointer function setup
 *
 * Rhett D. Jacobs <rdj@cea.com.au>
 * GNU Public Licence, 1996.
 *
 * Last Modified: 6/6/1996 <rdj>
 */

#include "graphics.h"
#include "x11.h"
#include "config.h"

extern Config config;

void (*graphics_refresh)(void);
void (*graphics_setup_display)(void);
void (*graphics_draw_field_border)(void);
void (*graphics_printxy)(char *, int, int);
void (*graphics_draw_player_positions)(void);
void (*graphics_clear_window)(int, int, int, int);
void (*graphics_close_display)(void);
void (*graphics_draw_player_borders)(void);
void (*graphics_draw_box)(int, int, int, int);
void (*graphics_field_display)(float, float, char *);
void (*graphics_refresh_plr)(void);
void (*graphics_clear_player_area)(void);
void (*graphics_draw_combat)(void);
void (*graphics_explode)(int);
void (*graphics_draw_explosions)(void);
void (*graphics_field_display_offset)(float, float, int, int, char *);
void (*graphics_remove_player)(int);


/* set_graphics - sets up the destination pointers for the graphics system,
 *  based on the desired output type.  Currently supported are:
 *   curses  <currently treated as ncurses> 
 *   ncurses
 *   Xlib    <not implemented yet>
 */
void set_graphics(int graphics_mode)
{
  config.graphics_mode = graphics_mode;

  switch(graphics_mode) {
  case XLIB:
    graphics_refresh = X11_refresh;
    graphics_setup_display = X11_setup_display;
    graphics_draw_field_border = X11_draw_field_border;
    graphics_printxy = X11_printxy;
    graphics_draw_player_positions = X11_draw_player_positions;
    graphics_clear_window = X11_clear_window;
    graphics_close_display = X11_close_display;
    graphics_draw_player_borders = X11_draw_player_borders;
    graphics_draw_box = X11_draw_box;
    graphics_field_display = X11_field_display;
    graphics_refresh_plr = X11_refresh_plr;
    graphics_clear_player_area = X11_clear_player_area;
    graphics_draw_combat = X11_draw_combat;
    graphics_explode = X11_explode;
    graphics_draw_explosions = X11_draw_explosions;
    graphics_field_display_offset = X11_field_display_offset;
    graphics_remove_player = X11_remove_player;
    break;
  };
  
  return;
}
