/* explosion.h - explosion routines for CodeWar
 *
 * Rhett D. Jacobs <rdj@cea.com.au>
 * GNU Public Licence, 1996.
 *
 * Last Modified: 9/3/96 <rdj>
 */

#ifndef _EXPLOSION_H
#define _EXPLOSION_H

#include "timers.h"

#define EXP_DISPLAY_TIME (500)  

typedef struct _Explosion_List {
  int id;
  short weapon;
  float position[2];
  timer_val remove;
  struct _Explosion_List *nextptr;
} Explosion_List;


int get_unique_exp_id(Explosion_List *search_list);
void add_explosion(short weapon, float centre_x, float centre_y, 
		   int display_time);
void add_explosion_list(Explosion_List *new, Explosion_List *list);
int remove_explosion(int id, Explosion_List **search_list);
int find_explosion(int id, Explosion_List **explosion_ptr, 
		   Explosion_List *search_list);

#endif
