/* explosion.c - routines for handling CodeWar explosions
 *
 * Rhett D. Jacobs <rdj@cea.com.au>
 * GNU Public Licence, 1996.
 *
 * Last Modified: 9/3/96 <rdj>
 */

#include <stdlib.h>

#include "explosion.h"
#include "misc.h"
#include "player.h"


Explosion_List *explosion_list = (Explosion_List *)NULL;


/* add_explosion - adds an explosion to the explosion list.
 */
void add_explosion(short weapon_type,
		   float centre_x, float centre_y, int display_time)
{
  Explosion_List *new_explosion;

  new_explosion = (Explosion_List *)calloc(1, sizeof(Explosion_List));
  set_timer(&new_explosion->remove, (long)1000 * (long)display_time);

  new_explosion->weapon = weapon_type;
  new_explosion->id = get_unique_exp_id(explosion_list);
  new_explosion->position[X_AXIS] = centre_x;
  new_explosion->position[Y_AXIS] = centre_y;

  add_explosion_list(new_explosion, explosion_list);

 return;
}


void add_explosion_list(Explosion_List *new, Explosion_List *list)
{
  Explosion_List *tmp;

  if (list == NULL)
    explosion_list = new;
  else {
    tmp = list;
    while (tmp->nextptr != NULL)
      tmp = tmp->nextptr;
    tmp->nextptr = new;
  }
  return;
}


/* get_unique_exp_id - finds a unique id for the system to use in assigning
 * a new weapon to the weapon list.
 */
int get_unique_exp_id(Explosion_List *search_list)
{
  int ret_val = 0;
  Explosion_List *tmp;

  if (search_list == NULL)
    return(ret_val);
  else {
    tmp = search_list;
    while (tmp != NULL) {
      if (tmp->id == ret_val)
	ret_val++;
      tmp = tmp->nextptr;
    }
  }
  return(ret_val);
}


/* find_explosion - finds a weapon entry in the weapon list.
 */
int find_explosion(int id, Explosion_List **explosion_ptr, 
		   Explosion_List *search_list)
{
  Explosion_List *tmp;

  if (search_list == NULL)
    return(FALSE);
  else {
    tmp = search_list;
    while (tmp != NULL) {
      if (tmp->id == id) {
	*explosion_ptr = tmp;
	return(TRUE);
      }
      tmp = tmp->nextptr;
    }
  }
  return(FALSE);
}


/* remove_explosion - removes an explosion from the explosion list.
 */
int remove_explosion(int id, Explosion_List **search_list)
{
  Explosion_List *tmp, *tmp2;

  if (*search_list != NULL)
    return(FALSE);
  else {
    tmp = *search_list;
    if (tmp->id == id) {
      if (tmp->nextptr == NULL) {
	*search_list = NULL;
	free(tmp);
      } else {
	*search_list = tmp->nextptr;
	free(tmp);
      }
    } else {
      tmp2 = tmp;
      tmp = tmp->nextptr;
      while (tmp != NULL) {
	if (tmp->id == id) {
	  tmp2->nextptr = tmp->nextptr;
	  free(tmp);
	  return(TRUE);
	} else {
	  tmp2 = tmp;
	  tmp = tmp->nextptr;
	}
      }
    }
  }

  return(TRUE);
}
