/* damage.h - Damage routines for CodeWar
 *
 * Rhett D. Jacobs <rdj@cea.com.au>
 * GNU Public Licence, 1996.
 *
 * Last Modified: 24/6/96 <rdj>
 */

#ifndef _DAMAGE_H
#define _DAMAGE_H

#include "player.h"

#define DMG_RANGE_MISSILE  (25.0)
#define DMG_RANGE_ATOMIC   (100000.0)
#define DMG_RANGE_CANNON   (10.0)
#define DMG_RANGE_BOMB     (50.0)
#define DMG_RANGE_CHARGE   (25.0)

#define DMG_FACTOR_MISSILE (2.5)
#define DMG_FACTOR_ATOMIC  (1.0)
#define DMG_FACTOR_CANNON  (5.0)
#define DMG_FACTOR_BOMB    (1.0)
#define DMG_FACTOR_CHARGE  (2.0)


void damage_check_players(short weapon, float x, float y);
int damage_calc(Player *plr, float distance, float range, float factor);

#endif
