/* damage.c - Damage routines for CodeWar
 *
 * Rhett D. Jacobs <rdj@cea.com.au>
 * GNU Public Licence, 1996.
 *
 * Last Modified: 24/5/96 <rdj>
 */

#include "weapon.h"
#include "misc.h"
#include "damage.h"
#include "player.h"

extern Player *play_list;
extern Resource_Defines rd;


void damage_check_players(short weapon, float x, float y)
{
  Player *plr, *temp_ptr;
  float range = 0.0, distance;
  float factor = 0.0;

  switch(weapon) {
  case WP_MISSILE:
    range = DMG_RANGE_MISSILE;
    factor = DMG_FACTOR_MISSILE;
    break;
  case WP_ATOMIC:
    range = DMG_RANGE_ATOMIC;
    factor = DMG_FACTOR_ATOMIC;
    break;
  case WP_CANNON:
    range = DMG_RANGE_CANNON;
    factor = DMG_FACTOR_CANNON;
    break;
  case WP_BOMB:
    range = DMG_RANGE_BOMB;
    factor = DMG_FACTOR_BOMB;
    break;
  case WP_CHARGE:
    range = DMG_RANGE_CHARGE;
    factor = DMG_FACTOR_CHARGE;
    break;
  }
  
  if (play_list != NULL) {
    plr = play_list;
    while (plr != NULL) {
      temp_ptr = plr->nextplr;
      if ((distance = pythagoras((x - plr->status.position[X_AXIS]), 
				 (y - plr->status.position[Y_AXIS]))) < range)
	damage_calc(plr, distance, range, factor);
      plr = temp_ptr;
    }
  }
}


/* damage_calc - X-Craft damage calculation function.  Damage is calculated
 * by consideration of two main factors:
 *   1. How far away from the center of the explosion the X-Craft was
 *      compared to the range of the weapon.
 *   2. A division factor which is designed to represent the relative 
 *      power of the explosion.
 */
int damage_calc(Player *plr, float distance, float range, float factor)
{
  int ret_val = FALSE;
  int damage = (int)((range - distance) / factor + 0.5);

  plr->status.shields -= damage;

  if (plr->status.shields <= 0) {
    damage = -plr->status.shields;
    plr->status.shields = 0;
    
    plr->status.damage += damage;

    if (plr->status.damage >= rd.damage_max) {
      remove_player(plr->socket, &play_list);
      ret_val = TRUE;
    }
  }

  return(ret_val);
}
