/* cw_client.h - CodeWar client message types
 *
 * Rhett D. Jacobs <rdj@cea.com.au>
 * GNU Public Licence
 *
 * Last Modified: 3/12/95 <rdj>
 */

#ifndef _CW_CLIENT_H
#define _CW_CLIENT_H

typedef struct {
  short Message_Type;
  char name[128];
  pid_t pid;
} Mess_Register_Program;

typedef struct {
  short Message_Type;
} Mess_Probe_Server;

typedef struct {
  short Message_Type;
  char buffer[255];
} Mess_Print_Buffer;

typedef struct {
  short Message_Type;
  float acceleration;
  float direction;
} Mess_Power;

typedef struct {
  short Message_Type;
  float direction;
  float range;
} Mess_Scan;

typedef struct {
  short Message_Type;
  float acceleration;
  float direction;
  float detinate;
} Mess_Missile;

typedef struct {
  short Message_Type;
  float acceleration;
  float direction;
  float detinate;
  int power;
} Mess_Charge;

typedef struct {
  short Message_Type;
  float acceleration;
  float direction;
  float detinate;
} Mess_Atomic;

typedef struct {
  short Message_Type;
  float velocity;
  float direction;
  float detinate;
} Mess_Cannon;

typedef struct {
  short Message_Type;
  float detinate;
} Mess_Bomb;

typedef struct {
  short Message_Type;
  int energy;
} Mess_Boost_Shields;

typedef struct {
  short Message_Type;
} Mess_Get_Status;

typedef struct {
  short Message_Type;
} Mess_Get_Config;

typedef struct {
  short Message_Type;
} Mess_Get_Channel;

typedef struct {
  short Message_Type;
  int channel;
  unsigned char data;
} Mess_Tx_Channel;

#endif
