/* src/config.h.  Generated automatically by configure.  */
/* config.h - CodeWar configuration parameters
 *
 * Rhett D. Jacobs <rdj@cea.com.au>
 * GNU Public Licence
 *
 * Last Modified: 3/12/95 <rdj>
 */

#ifndef _CONFIG_H
#define _CONFIG_H

#define VERSION 0.4

#define RENDEZVOUS              (5150)
#define MAX_PORT_BUFF           (512)

#define SCREEN_UPDATE	        (40000)
#define SIMULATE_INTERVAL       (40000)
#define XCRAFT_FORCE            (1000)

/* simulation settings */
#define TIME_INT                (((float)SIMULATE_INTERVAL)/1000000.0)

#define CW_BATTLE_X             (100)
#define CW_BATTLE_Y             (100)

#define GFX_WIDTH               (500)
#define GFX_HEIGHT              (500)

/* wall types:
 *     RUBBER - X-Craft bounce off walls on contact.
 *      STONE - X-Craft velocity stopped upon wall contact/damage.
 *      ABYSS - X-Craft are destroyed by wall contact.
 * TWIGHLIGHT - X-Craft transport to other side of battlefield.
 */
#define WALL_TYPE               RUBBER

#define CHANNEL_BANDWIDTH       (128)

/* X-Craft defaults */
#define DFT_WEAPONS_MISSILES    (100)
#define DFT_WEAPONS_ATOMICS     (0)
#define DFT_WEAPONS_CANNONS     (1000)
#define DFT_WEAPONS_BOMBS       (10)

#define DFT_STATUS_DAMAGE       (0)
#define DFT_STATUS_SHIELDS      (100)
#define DFT_STATUS_ENERGY       (100)
#define DFT_STATUS_VELOCITY     (0)
#define DFT_STATUS_HEADING      (0)
#define DFT_STATUS_ACCELERATION (0)
#define DFT_STATUS_SCAN         (-1.0)
#define DFT_STATUS_SCAN_DIR     (0.0)
#define DFT_STATUS_MASS         (10)
#define DFT_STATUS_POSITION_X   (float)(rand()%CW_BATTLE_X)
#define DFT_STATUS_POSITION_Y   (float)(rand()%CW_BATTLE_Y)

#define DAMAGE_MAX              (100)

/* graphics  */
#define X11_XCRAFT_MAX          (4)
#define X11_EXPLOSION_MAX       (7)
#define X11_XCRAFT_WIN_WIDTH    (250)
#define X11_XCRAFT_WIN_HEIGHT   (100)
#define X11_CHANNEL_WIN_WIDTH   (250)
#define X11_CHANNEL_WIN_HEIGHT  (100)

/* configure path files */
#define X11_PIXMAP_PATH "/home/rhett/CodeWar/src/pixmaps/"

#define X11_BACKDROP       	"backdrop.xpm"
#define X11_ICON           	"icon.xpm"
#define X11_XCRAFT         	"xcraft.xpm"
#define X11_CANNON         	"cannon.xpm"
#define X11_MISSILE        	"missile.xpm"
#define X11_CHARGE         	"charge.xpm"
#define X11_BOMB           	"bomb.xpm"
#define X11_ATOMIC         	"atomic.xpm"
#define X11_ANIM_EXPLOSION 	"explosion"
#define X11_SLOW           	"slow.xpm"
#define X11_SERVER_SLOW    	"server_slow.xpm"

#define NUM_XCRAFT_COLOURS      (4)
#define DFT_ANIM_DELAY          (75000)

#endif
