/* clt_rqs.h - client calls to CodeWar server
 *
 * Rhett D. Jacobs <rdj@cea.com.au>
 * GNU Public Licence
 *
 * Last Modified: 3/12/95 <rdj>
 */

#ifndef _CLT_RQS_H
#define _CLT_RQS_H

/* user callable functions */
int cw_register_network_program(char *name, char *hostname);
void cw_print_buffer(char *buffer);
void cw_power(float acceleration, float direction);
float cw_scan(float direction, float range);
void cw_missile(float acceleration, float direction, float detinate);
void cw_charge(float acceleration, float direction, float detinate,
	       int power);
void cw_atomic(float acceleration, float direction, float detinate);
void cw_cannon(float velocity, float direction, float detinate);
void cw_bomb(float detinate);
void cw_get_position(float *x, float *y);
int cw_get_damage(void);
int cw_get_shields(void);
int cw_get_mass(void);
float cw_get_velocity(float *x, float *y);
float cw_get_acceleration(float *x, float *y);
float cw_get_acceleration_setting(float *x, float *y);
int cw_get_missiles(void);
int cw_get_atomics(void);
int cw_get_cannons(void);
int cw_get_bombs(void);
float cw_get_time_interval(void);
int cw_get_xcraft_force(void);
void cw_get_field_limits(float *x_axis, float *y_axis);
int cw_get_boundary_type(void);
float cw_get_elapsed_time(void);
int cw_get_energy(void);
void cw_boost_shields(int energy);

int cw_get_channel_bandwidth(void);
unsigned char cw_channel_receive(int ch);
void cw_channel_transmit(int channel, unsigned char data);

void clt_send_message(int sock, unsigned char *data_type, int data_size);
void get_status_message(int player_socket, unsigned char *Message, int size);
void get_status_message(int player_socket, unsigned char *Message, int size);

#endif
