/* clt_rqs - client callable routines for CodeWar operation
 *
 * Rhett D. Jacobs
 *
 * Last Modified: 2/12/95 <rdj>
 */

#include <string.h>

#include "clt_rqs.h"
#include "misc.h"
#include "player.h"
#include "cw.h"
#include "cw_client.h"
#include "client.h"
#include "messages.h"

int player_socket;
Player player;
Config config;
Channel channel;
timer_val refresh_timer;
int acknowledge = FALSE;
int status_flag = FALSE;
int config_flag = FALSE;
int channel_flag = FALSE;


int cw_register_network_program(char *name, char *hostname)
{
  int ret_val = TRUE;
  Mess_Register_Program Message;

  Message.Message_Type = MT_REGISTER_PROGRAM;
  Message.pid = getpid();
  strcpy(Message.name, name);

  if (strlen(name) > 254)
    name[254] = (char)NULL;
  
  if ((player_socket = cw_client_init(hostname)) == FALSE) {
    error_print("a problem has occurred setting up connection",0,0);
    ret_val = FALSE;
  } else {
    clt_send_message(player_socket, (unsigned char *)&Message,
		     sizeof(Mess_Register_Program));
    set_timer(&refresh_timer, config.simulate_int);
  }
  
  return(ret_val);
}


void cw_print_buffer(char *buffer)
{
  Mess_Print_Buffer Message;

  if (strlen(buffer) > 254)
    buffer[254] = (char)NULL;
  
  Message.Message_Type = MT_PRINT_BUFFER;
  strcpy(Message.buffer, buffer);
  clt_send_message(player_socket, (unsigned char *)&Message,
	       sizeof(Mess_Print_Buffer)); 
  
  return;
}


void cw_power(float acceleration, float direction)
{
  Mess_Power Message;
  
  Message.Message_Type = MT_POWER;
  Message.acceleration = acceleration;
  Message.direction = direction;
  clt_send_message(player_socket, (unsigned char *)&Message,
	       sizeof(Mess_Power)); 
  
  return;
}


float cw_scan(float direction, float range)
{
  Mess_Get_Status GS_Message;
  Mess_Scan Message;

  Message.Message_Type = MT_SCAN;
  GS_Message.Message_Type = MT_GET_STATUS;

  Message.direction = direction;
  Message.range = range;
  clt_send_message(player_socket, (unsigned char *)&Message,
	       sizeof(Mess_Scan)); 
  get_status_message(player_socket, (unsigned char *)&GS_Message, 
	       sizeof(Mess_Get_Status));

  return(player.status.scan);
}


void get_status_message(int player_socket, unsigned char *Message, int size)
{
  status_flag = FALSE;

  clt_send_message(player_socket, Message, size);
  cw_client_process(player_socket, &status_flag);
  
  return;
}


void get_config_message(int player_socket, unsigned char *Message, int size)
{
  config_flag = FALSE;

  clt_send_message(player_socket, Message, size);
  cw_client_process(player_socket, &config_flag);
  
  return;
}


void get_channel_message(int player_socket, unsigned char *Message, int size)
{
  channel_flag = FALSE;

  clt_send_message(player_socket, Message, size);
  cw_client_process(player_socket, &channel_flag);
  
  return;
}


/* cw_missile - releases a missile in the specified direction.
 */
void cw_missile(float acceleration, float direction, float detinate)
{
  Mess_Missile Message;
  
  Message.Message_Type = MT_MISSILE;
  Message.acceleration = acceleration;
  Message.direction = direction;
  Message.detinate = detinate;
  clt_send_message(player_socket, (unsigned char *)&Message,
	       sizeof(Mess_Missile)); 
  
  return;
}


/* cw_charge - releases a missile in the specified direction.
 */
void cw_charge(float acceleration, float direction, float detinate, 
	       int power)
{
  Mess_Charge Message;
  
  Message.Message_Type = MT_CHARGE;
  Message.acceleration = acceleration;
  Message.direction = direction;
  Message.detinate = detinate;
  Message.power = power;
  clt_send_message(player_socket, (unsigned char *)&Message,
	       sizeof(Mess_Charge)); 
  
  return;
}


/* cw_atomic - releases a missile in the specified direction.
 */
void cw_atomic(float acceleration, float direction, float detinate)
{
  Mess_Atomic Message;
  
  Message.Message_Type = MT_ATOMIC;
  Message.acceleration = acceleration;
  Message.direction = direction;
  Message.detinate = detinate;
  clt_send_message(player_socket, (unsigned char *)&Message,
	       sizeof(Mess_Atomic)); 
  
  return;
}


/* cw_cannon - releases a missile in the specified direction.
 */
void cw_cannon(float velocity, float direction, float detinate)
{
  Mess_Cannon Message;
  
  Message.Message_Type = MT_CANNON;
  Message.velocity = velocity;
  Message.direction = direction;
  Message.detinate = detinate;
  clt_send_message(player_socket, (unsigned char *)&Message,
	       sizeof(Mess_Cannon)); 
  
  return;
}


/* cw_bomb - releases a missile in the specified direction.
 */
void cw_bomb(float detinate)
{
  Mess_Bomb Message;
  
  Message.Message_Type = MT_BOMB;
  Message.detinate = detinate;
  clt_send_message(player_socket, (unsigned char *)&Message,
	       sizeof(Mess_Bomb));
  
  return;
}


void clt_send_message(int sock, unsigned char *data_type, int data_size)
{
  acknowledge = FALSE;

  send_message(sock, data_type, data_size);
  cw_client_process(player_socket, &acknowledge);
}


void cw_get_position(float *x, float *y)
{
  Mess_Get_Status Message;

  Message.Message_Type = MT_GET_STATUS;
  
  get_status_message(player_socket, (unsigned char *)&Message, 
		     sizeof(Mess_Get_Status));
  *x = player.status.position[X_AXIS];
  *y = player.status.position[Y_AXIS];

  return;
}


int cw_get_damage(void)
{
  Mess_Get_Status Message;

  Message.Message_Type = MT_GET_STATUS;
  
  get_status_message(player_socket, (unsigned char *)&Message, 
		     sizeof(Mess_Get_Status));

  return(player.status.damage);
}


int cw_get_shields(void)
{
  Mess_Get_Status Message;

  Message.Message_Type = MT_GET_STATUS;
  
  get_status_message(player_socket, (unsigned char *)&Message, 
		     sizeof(Mess_Get_Status));

  return(player.status.shields);
}


int cw_get_mass(void)
{
  Mess_Get_Status Message;

  Message.Message_Type = MT_GET_STATUS;
  
  get_status_message(player_socket, (unsigned char *)&Message, 
		     sizeof(Mess_Get_Status));

  return(player.status.mass);
}


float cw_get_velocity(float *x, float *y)
{
  Mess_Get_Status Message;

  Message.Message_Type = MT_GET_STATUS;
  
  get_status_message(player_socket, (unsigned char *)&Message, 
		     sizeof(Mess_Get_Status));
  *x = player.status.velocity[X_AXIS];
  *y = player.status.velocity[Y_AXIS];

  return((float)(pythagoras((double)(player.status.velocity[X_AXIS]),
			    (double)(player.status.velocity[Y_AXIS]))));
}


float cw_get_acceleration(float *x, float *y)
{
  Mess_Get_Status Message;

  Message.Message_Type = MT_GET_STATUS;
  
  get_status_message(player_socket, (unsigned char *)&Message, 
		     sizeof(Mess_Get_Status));
  *x = player.status.acc_actual[X_AXIS];
  *y = player.status.acc_actual[Y_AXIS];

  return((float)(pythagoras((double)(player.status.acc_actual[X_AXIS]),
			    (double)(player.status.acc_actual[Y_AXIS]))));
}


float cw_get_acceleration_setting(float *x, float *y)
{
  Mess_Get_Status Message;

  Message.Message_Type = MT_GET_STATUS;
  
  get_status_message(player_socket, (unsigned char *)&Message, 
		     sizeof(Mess_Get_Status));
  *x = player.status.acc_desired[X_AXIS];
  *y = player.status.acc_desired[Y_AXIS];

  return((float)(pythagoras((double)(player.status.acc_desired[X_AXIS]),
			    (double)(player.status.acc_desired[Y_AXIS]))));
}


int cw_get_missiles(void)
{
  Mess_Get_Status Message;

  Message.Message_Type = MT_GET_STATUS;
  
  get_status_message(player_socket, (unsigned char *)&Message, 
		     sizeof(Mess_Get_Status));

  return(player.weapons.missiles);
}


int cw_get_atomics(void)
{
  Mess_Get_Status Message;

  Message.Message_Type = MT_GET_STATUS;
  
  get_status_message(player_socket, (unsigned char *)&Message, 
		     sizeof(Mess_Get_Status));

  return(player.weapons.atomics);
}


int cw_get_cannons(void)
{
  Mess_Get_Status Message;

  Message.Message_Type = MT_GET_STATUS;
  
  get_status_message(player_socket, (unsigned char *)&Message, 
		     sizeof(Mess_Get_Status));

  return(player.weapons.cannons);
}


int cw_get_bombs(void)
{
  Mess_Get_Status Message;

  Message.Message_Type = MT_GET_STATUS;
  
  get_status_message(player_socket, (unsigned char *)&Message, 
		     sizeof(Mess_Get_Status));

  return(player.weapons.bombs);
}


float cw_get_time_interval(void)
{
  Mess_Get_Config Message;

  Message.Message_Type = MT_GET_CONFIG;
  
  get_config_message(player_socket, (unsigned char *)&Message, 
		     sizeof(Mess_Get_Config));

  return(config.time_int);
}


int cw_get_xcraft_force(void)
{
  Mess_Get_Config Message;

  Message.Message_Type = MT_GET_CONFIG;
  
  get_config_message(player_socket, (unsigned char *)&Message, 
		     sizeof(Mess_Get_Config));

  return(config.xcraft_force);
}


void cw_get_field_limits(float *x_axis, float *y_axis)
{
  Mess_Get_Config Message;

  Message.Message_Type = MT_GET_CONFIG;
  
  get_config_message(player_socket, (unsigned char *)&Message, 
		     sizeof(Mess_Get_Config));

  *x_axis = config.field[X_AXIS];
  *y_axis = config.field[Y_AXIS];

  return;
}


int cw_get_boundary_type(void)
{
  Mess_Get_Config Message;

  Message.Message_Type = MT_GET_CONFIG;
  
  get_config_message(player_socket, (unsigned char *)&Message, 
		     sizeof(Mess_Get_Config));

  return(config.wall_type);
}


float cw_get_elapsed_time(void)
{
  Mess_Get_Config Message;

  Message.Message_Type = MT_GET_CONFIG;
  
  get_config_message(player_socket, (unsigned char *)&Message, 
		     sizeof(Mess_Get_Config));

  return(config.elapsed_time);
}


int cw_get_energy(void)
{
  Mess_Get_Status Message;

  Message.Message_Type = MT_GET_STATUS;
  
  get_status_message(player_socket, (unsigned char *)&Message, 
		     sizeof(Mess_Get_Status));
  
  return(player.status.energy);
}


void cw_boost_shields(int energy)
{
  Mess_Boost_Shields Message;

  Message.Message_Type = MT_BOOST_SHIELDS;
  Message.energy = energy;
  
  clt_send_message(player_socket, (unsigned char *)&Message,
		   sizeof(Mess_Boost_Shields)); 
  
  return;
}

int cw_get_channel_bandwidth(void)
{
  Mess_Get_Channel Message;

  Message.Message_Type = MT_GET_CHANNEL;
  
  get_channel_message(player_socket, (unsigned char *)&Message, 
		      sizeof(Mess_Get_Channel));

  return(channel.bandwidth);
}


unsigned char cw_channel_receive(int ch)
{
  Mess_Get_Channel Message;
  unsigned char ret_val = (unsigned char)NULL;

  Message.Message_Type = MT_GET_CHANNEL;
  
  get_channel_message(player_socket, (unsigned char *)&Message, 
		      sizeof(Mess_Get_Channel));
  
  if (ch < channel.bandwidth && ch >= 0)
    ret_val = channel.data[ch];

  return(ret_val);
}


void cw_channel_transmit(int channel, unsigned char data)
{
  Mess_Tx_Channel Message;

  Message.Message_Type = MT_TX_CHANNEL;
  Message.channel = channel;
  Message.data = data;

  clt_send_message(player_socket, (unsigned char *)&Message,
		   sizeof(Mess_Tx_Channel)); 
}
