/* clt_ops.c - client reply processing
 *
 * Rhett D. Jacobs <rdj@cea.com.au>
 * GNU Public Licence
 *
 * Last Modified: 3/12/95 <rdj>
 */

#include <stdio.h>

#include "clt_ops.h"
#include "player.h"
#include "cw_server.h"
#include "misc.h"

extern Player player;
extern Config config;
extern Channel channel;
extern int acknowledge;
extern int status_flag;
extern int config_flag;
extern int channel_flag;


void clt_Player_Status(void *extracted_message, int sock)
{
  Mess_Player_Status *Message = (Mess_Player_Status *)extracted_message;

  memcpy((void *)&player.weapons, (void *)&Message->weapons,
	 sizeof(CW_Weapons));
  memcpy((void *)&player.status, (void *)&Message->status,
	 sizeof(CW_Status));

  status_flag = TRUE;
  
  return;
}


void clt_Config_Status(void *extracted_message, int sock)
{
  Mess_Config_Status *Message = (Mess_Config_Status *)extracted_message;

  memcpy((void *)&config, (void *)&Message->config, sizeof(Config));

  config_flag = TRUE;

  return;
}


void clt_Channel_Status(void *extracted_message, int sock)
{
  Mess_Channel_Status *Message = (Mess_Channel_Status *)extracted_message;

  memcpy((void *)&channel, (void *)&Message->channel, sizeof(Channel));

  channel_flag = TRUE;

  return;
}


void clt_Acknowledge(void)
{
  acknowledge = TRUE;
}
