/* client.c - networking routines for CodeWar clients
 *
 * Rhett D. Jacobs <rdj@cea.com.au>
 * GNU Public Licence
 *
 * Last Modified: 3/12/95 <rdj>
 */

#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>

#include "client.h"
#include "misc.h"
#include "config.h"
#include "messages.h"

extern int player_socket;

fd_set player_client;


int cw_client_init(char *desiredhost)
{
  int sock;
  struct sockaddr_in server;
  struct hostent *hp;
  char localhost[255];
  
  /* create socket */
  sock = socket(AF_INET, SOCK_STREAM, 0);
  if (sock < 0) {
    perror("client - socket");
    return(FALSE);
  }
  
  /* connect socket using name specified in command line */
  server.sin_family = AF_INET;
  if (desiredhost == NULL)  {
    if (gethostname(localhost, 255) == -1)  {
      perror("client - gethostname");
      return(FALSE);
    }
  } else
    strcpy(localhost, desiredhost);

  hp = gethostbyname(localhost);
  if (hp == 0) {
    error_print("%s is an unknown host",0,0);
    return(FALSE);
  }
  bcopy((char *) hp->h_addr, (char *) &server.sin_addr, hp->h_length);
  server.sin_port = htons(RENDEZVOUS);

  if (connect(sock, (struct sockaddr *)&server, sizeof server) < 0) {
    perror("client - connect");
    return(FALSE);
  }

  FD_ZERO(&player_client);
  FD_SET(sock, &player_client);
  
  return(sock);
}


int cw_client_process(int read_socket, int *control_flag)
{
  fd_set ready;
  struct timeval to;
  unsigned char buffer[MAX_BUF_SIZE];
  int fd, buf_size;
  
  to.tv_sec = CLIENT_SEC;
  to.tv_usec = CLIENT_USEC;

  FD_ZERO(&ready);

  while(*control_flag == FALSE) {

    memcpy((void *)&ready, (void *)&player_client, (size_t)sizeof(fd_set));
    fd = select(FD_SETSIZE, &ready, NULL, NULL, &to);
    
    switch(fd) {
    case -1:
      close(player_socket);
      perror("client - select");
      exit(1);
      break;
    case 0: 
      break;
    default:
      if (FD_ISSET(read_socket, &ready)) {
	buf_size = read(read_socket, buffer, MAX_BUF_SIZE);
	switch(buf_size) {
	case -1:
	  perror("client - read");
	  exit(1);
	  break;
	case 0:
	  fprintf(stderr,"client - zero returned.\n");
	  exit(1);
	  break;
	default:
	  process_message(read_socket, buffer, buf_size);
	  break;
	}
      }
    }
  }

  return(TRUE);
}


void cw_client_close(int sock)
{ 
  close(sock);
}
