/* CodeWar.c - main server file.
 *
 * Rhett D. Jacobs <rdj@cea.com.au>
 * GNU Public Licence.
 *
 * Last Modified: 13/1/96
 */

#include <stdlib.h>
#include <time.h>

#include "server.h"
#include "misc.h"
#include "graphics.h"
#include "resource.h"

extern Resource_Defines rd;


/* parse_input - position independent input parser
 */
void parse_input(int argc, char **argv)
{
  if (argc > 0) {
    switch(argv[0][0]) {
    case '-':
      switch (argv[0][1]) {
      case 'd':
	if (!(strcmp(argv[1], "X11"))) {
	  set_graphics(XLIB);
	  parse_input(argc-2, &argv[2]);
	} else 
	  parse_input(argc-1, &argv[1]);
	break;
      default:
	parse_input(argc-1, &argv[1]);
	break;
      }
      break;
    default:
      if (!(fork()))
	execlp(argv[0], argv[0], (char *)NULL);
      parse_input(argc-1, &argv[1]); 
      break;
    }
  }
}


void main(int argc, char **argv)
{
  /* seed random numbers */
  srand(time(NULL)%RAND_MAX);

  if (cw_server_init()) {

    /* if X server connection cannot be made will default to ncurses */
    set_graphics(XLIB);

    parse_input(argc-1, &argv[1]);
    
    set_config_defaults();
    codewar_resources();
    set_defaults();

    graphics_setup_display();
    
    signal(SIGINT, cw_server_close);
    signal(SIGQUIT, cw_server_close);
    
    cw_server_process();

    graphics_close_display();
  }
  
  return;
}
