/* schedule.c - priority scheduler routines
 *
 * Rhett D. Jacobs <rdj@cea.com.au>
 * GNU Public Licence, 1997.
 *
 * Last Modified: <rdj>
 */

#include <stdio.h>

#include "schedule.h"


void schedule_function_list(f_type *f_list, int f_size)
{
  int i, count;

  count = schedule_next_function(f_list, f_size);

  /* decrease the scheduled priority of this function */
  f_list[count].current_priority--;

  if (!(f_list[count].f_ptr())) {
    
    /* if a FALSE return value is returned from the called function, 
     * then this function should no longer be called.  Therefore, all 
     * "higher" functions need to be shifted down and the called function
     * removed.
     */
    for (i = count; i < f_size - 1; i++)
      f_list[i] = f_list[i+1];
    f_size--;
  }
}


/* schedule_next_function - this routines handles the priority scheduling.
 */
int schedule_next_function(f_type *f_list, int f_size)
{
  int ret_val, i, index = 0, count = 0;

  /* find the highest priority task */
  for (i = 0; i < f_size; i++)
    if (f_list[i].current_priority > count) {
      count = f_list[i].current_priority;
      index = i;
    }

  ret_val = index;

  /* check if priorities require refreshing */
  if (count == 0) {
    for (i = 0; i < f_size; i++)
      f_list[i].current_priority = f_list[i].priority;

    ret_val = schedule_next_function(f_list, f_size);
  }

  return(ret_val);
}
