/* utils.c - X-Craft position utilities
 *
 * Rhett D. Jacobs <rdj@lab.cea.com.au> || <rhett@hotel.canberra.edu.au>
 * GNU Public Licence, 1996.
 *
 * Last Modified: <rdj>
 */

#include <stdlib.h>
#include <math.h>

#include "codewar.h"
#include "utils.h"

#define STOP_TOLERANCE  (0.25)

void(*func_ptr)(void) = NULL;


void cw_stop(float tolerance)
{
  int exit_flag = 0;
  float time_initial;
  float new_time;
  float val, x_val, y_val;

  /* cut engine power */
  cw_power(0.0, 0.0);
  val = cw_get_velocity(&x_val, &y_val);
    
  if (val > tolerance) {
    
    while (!(exit_flag)) {
      
      time_initial = cw_get_elapsed_time();
      
      cw_power(1.0, 180.0+rad_2_deg((float)atan2((float)y_val, (float)x_val)));
      
      while ((new_time = cw_get_elapsed_time()) <= (time_initial + val))
	if (func_ptr != NULL)
	  func_ptr();
      
      cw_power(0.0, 0.0);
      
      if ((val = cw_get_velocity(&x_val, &y_val)) <= tolerance)
	exit_flag = 1;
    }

    if (func_ptr != NULL)
      func_ptr();
  }

  return;
}


void cw_go(float x, float y)
{
  float delta_time, new_time, time_initial;
  float distance, system_interval, ang;
  float current_x, current_y;

  cw_stop(STOP_TOLERANCE);
  cw_get_position(&current_x, &current_y);    

  system_interval = cw_get_time_interval();
  distance = pythagoras((float)current_y-y, (float)current_x-x);
  ang = atan2(y - current_y, x - current_x);

  delta_time = (float)sqrt(2.0*(double)distance)*(0.5) + system_interval;

  time_initial = cw_get_elapsed_time();
  cw_power(1.0, rad_2_deg(ang));
 
  while ((new_time = cw_get_elapsed_time()) < time_initial + delta_time)
    if (func_ptr != NULL)
      func_ptr();

  time_initial = cw_get_elapsed_time();
  cw_power(1.0, rad_2_deg(ang) + 180.0);
  while ((new_time = cw_get_elapsed_time()) < time_initial + delta_time)
    if (func_ptr != NULL)
      func_ptr();
  
  cw_stop(STOP_TOLERANCE);
}


