/* main.c - Gumby v0.4
 *
 * Rhett D. Jacobs <rdj@cea.com.au>
 * GNU Public Licence, 1996.
 *
 * Gumby is a fodder X-Craft
 *
 * Last Modified: <rdj>
 */

#include <stdlib.h>
#include <stdio.h>
#include <math.h>

#include "codewar.h"
#include "main.h"
#include "utils.h"


/* the utils.c functions make use of the pointer to function func_ptr, which
 * can be set to point to a function which will be called at regular interval
 * whilst the X-Craft is moving to the desired position.
 */
extern void(*func_ptr)(void);

char output_buffer[255];

void write_garbage(void);


/* init - simple setup routine.  Assigns a periodic handler pointer for
 * use by the utils.c functions, and registers the X-Craft with the 
 * CodeWar server.
 */
int init(char *hostname)
{
  int ret_val = FALSE;


  func_ptr = write_garbage;

  sprintf(output_buffer,"Gumby v%0.1f", VERSION);

  if (cw_register_network_program(output_buffer, hostname))
    ret_val = TRUE;

  return(ret_val);
}


/* write_garbage - transmits random garbage to the open channel in an 
 * attempt to disrupt any Inter X-Craft Communication (IXC)
 */
void write_garbage(void)
{
  static int bandwidth;
  static int first = 1;

  if (first)
    bandwidth = cw_get_channel_bandwidth();
  
  cw_channel_transmit(rand()%bandwidth, rand()%512);
}


void main(int argc, char **argv)
{
  char *hostname = (char *)NULL;
  float max_x, max_y;
  float dest_x, dest_y;

  srand(1);

  if (argc > 1)
    hostname = argv[1];

  if (init(hostname)) {
    cw_get_field_limits(&max_x, &max_y);

    for (;;) {
      dest_x = (float)(rand()%(int)max_x);
      dest_y = (float)(rand()%(int)max_y);
      sprintf(output_buffer, "Heading off to %0.1f, %0.1f",
	      dest_x, dest_y);
      cw_print_buffer(output_buffer);

      cw_go(dest_x, dest_y);
    }
  }
}
