/* codewar.h - Player callable CodeWar functions
 *
 * Rhett D. Jacobs <rdj@lab.cea.com.au> || <rhett@hotel.canberra.edu.au>
 * GNU Public Licence
 *
 * Last Modified: 10/12/95 <rdj>
 */

#ifndef _CODEWAR_H
#define _CODEWAR_H

#define cw_register_program(name)       cw_register_network_program(name, NULL)

extern int cw_register_network_program(char *name, char *hostname);
extern void cw_print_buffer(char *buffer);
extern void cw_power(float acceleration, float direction);
extern float cw_scan(float direction, float range);
extern void cw_missile(float acceleration, float direction, float detinate);
extern void cw_charge(float acceleration, float direction, float detinate, 
		      int power);
extern void cw_atomic(float acceleration, float direction, float detinate);
extern void cw_cannon(float velocity, float direction, float detinate);
extern void cw_bomb(float detinate);
extern void cw_get_position(float *x, float *y);
extern int cw_get_damage(void);
extern int cw_get_shields(void);
extern int cw_get_mass(void);
extern float cw_get_velocity(float *x, float *y);
extern float cw_get_acceleration(float *x, float *y);
extern float cw_get_acceleration_setting(float *x, float *y);
extern float cw_get_time_interval(void);
extern int cw_get_xcraft_force(void);
extern void cw_get_field_limits(float *x_axis, float *y_axis);
extern int cw_get_boundary_type(void);
extern float cw_get_elapsed_time(void);
extern int cw_get_missiles(void);
extern int cw_get_atomics(void);
extern int cw_get_cannons(void);
extern int cw_get_bombs(void);
extern int cw_get_energy(void);
extern void cw_boost_shields(int energy);
extern int cw_get_channel_bandwidth(void);
extern unsigned char cw_channel_receive(int ch);
extern void cw_channel_transmit(int channel, unsigned char data);

#endif
