#include "wcli.h"

class CWormUI : public CWormClient
{
protected:
	WINDOW* p_winMain;
	char m_szInputBuffer[100];
	char* m_pcInputBuffer;
	unsigned char m_szCharMap[256];
	CTimer timerInputDelay;
	int nUserInputDelay;

protected:
	bool IsInputPending() { return m_pcInputBuffer != m_szInputBuffer; }
	void DiscardTypedAhead() { ReadInput(); m_pcInputBuffer = m_szInputBuffer; }
	void InitKeyMap();
	void Remap(unsigned char ucOldChar, unsigned char ucNewChar); 
	unsigned char TtyToProtocolKey(int nTerminalInput);
	void ReadInput();
	void Refresh();
	int PrintUsage();
protected:
	virtual bool Initialize();
	virtual bool Uninitialize();
	virtual bool OnRefresh();
	virtual bool OnDeath(int nPlayer);
	virtual bool OnDisconnect(int nPlayer);
	virtual bool OnScore(int nPlayer, long lScore);
	virtual bool OnLives(int nPlayer, long lLives);
	virtual bool OnStoppedDueTo(int nPlayer);

	virtual bool OnCellEmpty(int nX, int nY);
	virtual bool OnCellPlayer(int nX, int nY, int nPlayer);
	virtual bool OnCellPrize(int nX, int nY, int nValue);
	virtual bool OnCellWall(int nX, int nY);
		
	virtual unsigned char GetInput();

	void Draw(int nY, int nX, char ch);
public:
	CWormUI();
	void Run(int argc, char** argv);
};
