extern "C"
{
#include <fcntl.h>
#include <string.h>

#ifndef LINUX
#include <stropts.h>
#include <sys/filio.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>

#ifndef GNUWIN32
#include <malloc.h>
#endif

#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <signal.h>

#include <stdlib.h> // random(), atoi()
#include <unistd.h> // close()
#include <stdio.h>
#include <errno.h>
}

#include "common.h"
#include "rcvbytes.h"

#define MAX_PRIZE 9
#define DEATH_PENALTY 10
#define INIT_LENGTH 1
#define INITIAL_LIVES 3
#define BONUS_LENGTH 60

class CLink
{
public:
	int nX;
	int nY;
	CLink* pNext;
public:
	CLink() : pNext(NULL){}
};

class CWorm
{
public:
	CLink* pHead;
	CLink* pTail;

	int nDX;
	int nDY;
	char chUsed;

	int nExcess;
	long lScore;
	long lLives;
	long lLength;

public:
	CWorm() : pHead(NULL), pTail(NULL), nDX(0), nDY(0), nExcess(0),
				lLives(INITIAL_LIVES), lScore(0), lLength(0) {}
	~CWorm() {Free();}
	void Free()
	{
		while(pTail)
		{
			pHead = pTail->pNext;
			delete pTail;
			pTail = pHead;
		}
		pHead = pTail = NULL;
	}
	int IsEmpty() {return (pHead == NULL);}
	void SetDirection(int _nDX, int _nDY) {nDX = _nDX; _nDY = nDY;}

	void SetPosition(int nX, int nY, int nLen)
	{
		Free(); 
		for(int i = 1; i <= nLen; i++)
		{
			CLink* pTemp = new CLink;
			pTemp->nX = nX-nDX*(nLen-i);
			pTemp->nY = nY-nDY*(nLen-i);
			pTemp->pNext = NULL;
		
			if(pHead) pHead->pNext = pTemp;
			else pTail = pTemp;

			pHead = pTemp;
		}
	}
};

class CConnection
{
public:
	int sock;
	CWorm worm;
public:
};


CConnection connections[100];
int consc = 0;
int g_nWrite;
int g_nConnections = 0;

unsigned char szCommand[10000];
unsigned char szInit[10000];

void PackCmdScore(int nWorm, unsigned char*& rp_ucCurrent);
void PackCmdLives(int nWorm, unsigned char*& rp_ucCurrent);

class CField
{
private:
	unsigned char **ppData;
	int nWidth, nHeight;
public:
	CField(int _nWidth, int _nHeight)
	{
		nWidth = _nWidth; nHeight = _nHeight;
		ppData = new unsigned char*[nHeight+1];
		for(int i = 0; i < nHeight; i++) 
			ppData[i] = new unsigned char[nWidth+1];
		Clear();
	}
	~CField() 
	{
		for(int i = 0; i <= nHeight; i++) delete [] ppData[i];
		delete [] ppData;
	}
	//--------------------------------------------
	void Clear()
	{
		for(int i = 0; i < nHeight; i++) 
			for(int j = 0; j < nWidth; j++) ppData[i][j] = EMPTY_SQUARE;
	}
	//-------------------------------------------
	void DrawBorder()
	{
		for(int i = 0; i < nHeight; i++)
		{
			ppData[i][0] = ppData[i][nWidth-1] = MASK_OTHER;
		}
	
		for(int i = 0; i < nWidth; i++)
		{
			ppData[0][i] = ppData[nHeight-1][i] = MASK_OTHER;
		}
	}

	unsigned char* operator[](int nIndex)
	{
		return ppData[nIndex];
	}

	void GetRandomFreePos(int& nX, int& nY)
	{
		while(1)
		{
			nX = random()%(nWidth-3)+1;
			nY = random()%(nHeight-3)+1;

			if((*this)[nY][nX] == EMPTY_SQUARE) return;

			// will hang if all the squares are nonempty
		}
	}

	void Send(int sock, unsigned char nPlayerID)
	{
		unsigned char *pcInit = szInit;
		*pcInit++ = CHAR_COMMAND;
		*pcInit++ = CHAR_YOURID;
		*pcInit++ = nPlayerID;

		for(int i = 0; i < nHeight; i++)
			for(int j = 0; j < nWidth; j++)
				if((*this)[i][j] != ' ')
				{
					(*pcInit++) = i;
					(*pcInit++) = j;
					(*pcInit++) = (*this)[i][j];
				}

		for(int i = 0; i < consc; i++)
		{
			if (connections[i].sock != -1) {
				PackCmdScore(i, pcInit);
				PackCmdLives(i, pcInit);
			}
		}

		send(sock, szInit, (pcInit - szInit), 0);
	}
};
CField* field;

fd_set g_fdsetClientsAndListening;
int g_nMaxDescriptorBitsToSelect = 0;

void OnSigPipe(...)
{
	printf("Sig PIPE received\n");
	signal(SIGPIPE, OnSigPipe);
}

//*****************************************************************************
//*****************************************************************************

bool
IsAnyonePlaying()
{
	return g_nConnections != 0;
}

void
IncPlayers()
{
	g_nConnections++;
}

void
DecPlayers()
{
	g_nConnections--;
}
	
//*****************************************************************************
//*****************************************************************************
int
GetFreeConnectionIndex()
{
	for (int i = 0; i < consc; i++)
		if (connections[i].sock == -1)
			return i;

	return consc++;
}

//*****************************************************************************
//*****************************************************************************
void
PackLong(

	unsigned char*& rp_ucCurrent,
	long l

) {
	unsigned long lS = l;
	(*rp_ucCurrent++) = char(lS & 0xFF); lS >>= 8;
	(*rp_ucCurrent++) = char(lS & 0xFF); lS >>= 8;
	(*rp_ucCurrent++) = char(lS & 0xFF); lS >>= 8;
	(*rp_ucCurrent++) = char(lS & 0xFF); lS >>= 8;
/*
	long* plC = (long*)pcCurrent;
	*plC = lS;
	rp_ucCurrent += sizeof(long);
*/
}

//*****************************************************************************
//*****************************************************************************
void
PackCmdScore(

	int nWorm,
	unsigned char*& rp_ucCurrent

)
{
	(*rp_ucCurrent++) = CHAR_COMMAND;
	(*rp_ucCurrent++) = CHAR_SCORE;
	(*rp_ucCurrent++) = nWorm;

	PackLong(rp_ucCurrent, connections[nWorm].worm.lScore);
}

//*****************************************************************************
//*****************************************************************************
void
PackCmdLives(

	int nWorm,
	unsigned char*& rp_ucCurrent

)
{
	(*rp_ucCurrent++) = CHAR_COMMAND;
	(*rp_ucCurrent++) = CHAR_LIVES;
	(*rp_ucCurrent++) = nWorm;

	PackLong(rp_ucCurrent, connections[nWorm].worm.lLives);
}

//*****************************************************************************
//*****************************************************************************

void
StopAll(int i, unsigned char*& pcCurrent)
{
	// Stop all
	// ========

	for(int j = 0; j < consc; j++)
	{
		connections[j].worm.nDX = 0;
		connections[j].worm.nDY = 0;
	}
	*pcCurrent++ = CHAR_COMMAND;
	*pcCurrent++ = CHAR_STOPPED_DUE_TO;
	*pcCurrent++ = (unsigned char) i;
}

//*****************************************************************************
//*****************************************************************************

CreateWorm(int i, unsigned char*& pcCurrent)
{
	StopAll(i, pcCurrent);
	CWorm& Worm = connections[i].worm;

	Worm.lLength = 1;
	Worm.Free(); // seems redundant
	Worm.nExcess = INIT_LENGTH;

	int nX, nY;
	field->GetRandomFreePos(nX, nY);
	Worm.SetPosition(nX, nY, 1);

	CLink* pLink = Worm.pTail;
	while(pLink)
	{
		*(pcCurrent++)=pLink->nY;
		*(pcCurrent++)=pLink->nX;
		*(pcCurrent++)=Worm.chUsed;
		(*field)[pLink->nY][pLink->nX] = Worm.chUsed;

		pLink = pLink->pNext;
	}

	// Send Score
	/// =========

	PackCmdScore(i, pcCurrent);
	PackCmdLives(i, pcCurrent);
}

//*****************************************************************************
//*****************************************************************************

/*
void CField::PrintField()
{
	for(int i = 0; i < nHeight; i++)
	{
		for(int j = 0; j < nWidth; j++)
			printf("%c", (*this)[i][j]);
		printf("\n");
	}
	printf("\n");
}

#define PrintField() (field->PrintField())
*/

//*****************************************************************************
//*****************************************************************************

void
KillWorm(int i, unsigned char*& pcCurrent)
{
	//PrintField();
	CLink* pLink = connections[i].worm.pTail;
	while(pLink)
	{
		*(pcCurrent++)=pLink->nY;
		*(pcCurrent++)=pLink->nX;
		*(pcCurrent++)=EMPTY_SQUARE;
		(*field)[pLink->nY][pLink->nX] = EMPTY_SQUARE;

		pLink = pLink->pNext;
	}

	connections[i].worm.Free();

	(*pcCurrent++)=CHAR_COMMAND;
	(*pcCurrent++)=CHAR_DEATH;
	(*pcCurrent++)=i;

	connections[i].worm.lScore -= DEATH_PENALTY;
	connections[i].worm.lLives--;
}

void
DisconnectWorm(int i, unsigned char*& pcCurrent)
{
	(*pcCurrent++)=CHAR_COMMAND;
	(*pcCurrent++)=CHAR_DISCONNECT;
	(*pcCurrent++)=i;

	// Write this to the dead guy
	// ==========================
	// send(connections[i].sock, pcCurrent-3, 3, 0);

	shutdown(connections[i].sock, 2);
	close(connections[i].sock);
	FD_CLR(connections[i].sock, &g_fdsetClientsAndListening);
	connections[i].sock = -1; // !!! HACK !!! invalid socket
	DecPlayers();
	printf ("Disconnected %d\n", i);
}

void
MakeLifeSpent(int i, unsigned char*& pcCurrent)
{
	KillWorm(i, pcCurrent);

	if (connections[i].worm.lLives)
		CreateWorm(i, pcCurrent);
	else
		DisconnectWorm(i, pcCurrent);
}
	
KillAndDisconnectWorm(int i, unsigned char*& pcCurrent)
{
	KillWorm(i, pcCurrent);
	DisconnectWorm(i, pcCurrent);
}
	
//*****************************************************************************
//*****************************************************************************

void GeneratePrize(unsigned char*& pcCurrent)
{
	int nPrize = random() % MAX_PRIZE + 1;

	int nX;
	int nY;
	field->GetRandomFreePos(nX, nY);

	(*field)[nY][nX] = MASK_PRIZE | nPrize;
	(*pcCurrent++) = nY;
	(*pcCurrent++) = nX;
	// printf("Created prize %d (%d)\n", nPrize, MASK_PRIZE | nPrize);
	(*pcCurrent++) = MASK_PRIZE | nPrize;
}

//*****************************************************************************
//*****************************************************************************

/*
	Usage examples:
		boaserv
		boaserv 239
			to run on port other than DEFAULT_PORT
		boaserv 239 40
			to run on port other than DEFAULT_PORT
			with field width other than FIELD_WIDTH
		boaserv 239 40 20
			...
			with field height other than FIELD_HEIGHT
*/
main(int argc, char **argv)
{
	int nWidth, nHeight;

	nWidth = (argc > 2)?atoi(argv[2]):FIELD_WIDTH;
	nHeight = (argc > 3)?atoi(argv[3]):FIELD_HEIGHT;
	
	// Shrink larger fields so that the hardwired boabot doesn't crash
	if (nWidth > FIELD_WIDTH) nWidth = FIELD_WIDTH;
	if (nHeight > FIELD_HEIGHT) nHeight = FIELD_HEIGHT;
	
	CField TheMainField(nWidth, nHeight);
	field = &TheMainField;

	fd_set readfds, deadfds;
	char str[1000];
	int obj;
	timeval timeout, *tp;
	sockaddr_in con_addr;
	int nsoc;

	FD_ZERO(&g_fdsetClientsAndListening);
	signal(SIGPIPE, OnSigPipe);

	// Initialize the field
	// ====================
	
	field->Clear();
	field->DrawBorder();

	// Generate a new prize. No need to remember commands, as the field will
	// be sent in its entirety to all clients
	// =====================================================================

	unsigned char* pcTemp = szCommand;
	GeneratePrize(pcTemp);

	//PrintField();

	// Prepare the server for connections
	// ==================================


    int soc = socket(AF_INET,SOCK_STREAM,0);

	sockaddr_in server;
    server.sin_family=AF_INET;
    server.sin_addr.s_addr = INADDR_ANY;

    server.sin_port = htons((argc > 1)?atoi(argv[1]):DEFAULT_PORT);

    if(bind(soc, 
			(struct sockaddr*) &server,
			sizeof(struct sockaddr_in)))
    {
        perror("Bind Error");
        exit(1);
    }
    listen(soc, 5);
	FD_SET(soc, &g_fdsetClientsAndListening);
	g_nMaxDescriptorBitsToSelect = soc + 1;

	int len = sizeof(struct sockaddr_in);

	consc = 0;

	// Loop forever
	// ============
	printf ("Boa server started on port %d, field (%d x %d)\n",
		ntohs(server.sin_port), nWidth, nHeight);

	while(1) 
	{
		unsigned char* pcCurrent = szCommand;

		// Check if any connections are pending
		// ====================================

		FD_ZERO(&readfds);
		FD_SET(soc, &readfds);
			
		timeout.tv_usec = 0;
		timeout.tv_sec = 0;

		int n;
		while((n = select(soc + 1, &readfds, NULL, NULL, 
			IsAnyonePlaying() ? &timeout : 0)) < 0)
			printf("Trouble\n");
		if(n != 0) 
		{
			//printf ("n = %d\n", n); // must always be 1
			// New connections are found!
			// ==========================
			nsoc = accept(soc, 
				(struct sockaddr*) &con_addr, 
				&len);

			if (nsoc < 0) {
				perror("select O.K., accept() failed");
				continue;
			}

			IncPlayers();

			FD_SET(nsoc, &g_fdsetClientsAndListening);
			if (nsoc >= g_nMaxDescriptorBitsToSelect)
				g_nMaxDescriptorBitsToSelect = nsoc + 1;
				
			int nNewConnectionIndex = GetFreeConnectionIndex();

			connections[nNewConnectionIndex].sock = nsoc;
			connections[nNewConnectionIndex].worm.chUsed = MASK_PLAYER
				| nNewConnectionIndex;
			connections[nNewConnectionIndex].worm.lScore = 0;
			connections[nNewConnectionIndex].worm.lLives = INITIAL_LIVES;

			// Create a new worm in a random place
			// ===================================

			CreateWorm(nNewConnectionIndex, pcCurrent);

			// Send the current information about the field to the new client
			// ==============================================================

			field->Send(nsoc, nNewConnectionIndex);

			printf("New connection -- %d!\n", nNewConnectionIndex);
		}

		// Write requests for user input to all the clients
		// ================================================

		char str[4];
		str[0] = CHAR_COMMAND;
		str[1] = CHAR_REQUEST_USER_INPUT;
		str[2] = 0;

		for(int i = 0; i < consc; i++)
		{
			if (connections[i].sock == -1) continue;

			g_nWrite = i;
			send(connections[i].sock, str, 3, 0);
		}

		//printf("Written requests\n");

		// Read user inputs from every client
		// ==================================

		// Sleep until any client responds or a new client connects
		{
			fd_set readfds(g_fdsetClientsAndListening);
			while(
				select(g_nMaxDescriptorBitsToSelect, &readfds, NULL, NULL, 0)
				<= 0
			)
				printf("select() interrupted\n");
		}

		//printf("Client responded/new connection\n");

		timeval tvTotalClientsTimeout;
		tvTotalClientsTimeout.tv_usec = 0;
		tvTotalClientsTimeout.tv_sec = 25;

		for(int i = 0; i < consc; i++)
		{
			if (connections[i].sock == -1)
				continue;

			g_nWrite = i;
			str[0] = 0;

			if(!RecvBytes(connections[i].sock, str, 1, tvTotalClientsTimeout))
			{
				/*
				if (errno) {
				}
				else {
					// Error 0
				}
				*/
				printf("%d --- no response \n", i);
				if (errno) perror ("recv() failed");

				// Disconnect this shmuk
				// =====================
				KillAndDisconnectWorm(i, pcCurrent);
				continue;
			}
			
			//printf("%d <-- %c\n", i, str[0]);

			// Compute the new directions for this client accordingly
			// ======================================================

			CWorm& Worm = connections[i].worm;

			bool bWasStanding = (Worm.nDX == 0 && Worm.nDY == 0);

			switch(str[0])
			{
			case 'h':
				if(Worm.nDX != 1)
				{
					Worm.nDX=-1;
					Worm.nDY=0;
				}
				break;
			case 'j':
				if(Worm.nDY != -1)
				{
					Worm.nDY=1;
					Worm.nDX=0;
				}
				break;
			case 'l':
				if(Worm.nDX != -1)
				{
					Worm.nDX=1;
					Worm.nDY=0;
				}
				break;
			case 'k':
				if(Worm.nDY != 1)
				{
					Worm.nDY=-1;
					Worm.nDX=0;
				}
				break;
			}

			// Check that it is not a move back from standing still
			// ====================================================

			if(bWasStanding && Worm.pHead && 
				(*field)[Worm.pHead->nY+Worm.nDY][Worm.pHead->nX+Worm.nDX] ==
					Worm.chUsed)
			{
				// Cancel that command
				// ===================

				Worm.nDX = Worm.nDY = 0;
			}
		}

		//printf("Read\n");

		// Move the worms according to their directsions
		// =============================================

		for(int i = 0; i < consc; i++)
		{
			if (connections[i].sock == -1) continue;

			CWorm& Worm = connections[i].worm;
			if(Worm.nDX == 0 && Worm.nDY == 0) continue;

			// Erase the tail, unless there is unrealized length
			// =================================================

			if(Worm.nExcess == 0)
			{
				// Erase the tail
				// ==============

				*(pcCurrent++) = Worm.pTail->nY;
				*(pcCurrent++) = Worm.pTail->nX;
				*(pcCurrent++) = EMPTY_SQUARE;

				(*field)[Worm.pTail->nY][Worm.pTail->nX] = EMPTY_SQUARE;

				CLink* pLink = Worm.pTail;
				Worm.pTail = pLink->pNext;
				delete pLink;
			}
			else {
				Worm.nExcess--;
				if ((++(Worm.lLength) % BONUS_LENGTH) == 0) {
					//printf("Granting life\n");
					Worm.lLives++;
					PackCmdLives(i, pcCurrent);
				}
			}
				
			// Create a new head
			// =================

			CLink* pLink = new CLink;
			pLink->nY = Worm.pHead->nY + Worm.nDY;
			pLink->nX = Worm.pHead->nX + Worm.nDX;

			// Check that that square is open
			// ==============================

			//printf("Check ability\n");
			switch((*field)[pLink->nY][pLink->nX] & MASK_ALL)
			{
			case MASK_PRIZE:
				// Extend the worm by the amount of the prize
				// ==========================================

				Worm.nExcess += (*field)[pLink->nY][pLink->nX] & MASK_REST;
				*(pcCurrent++)=CHAR_COMMAND;
				*(pcCurrent++)=CHAR_ATE;
				*(pcCurrent++)=Worm.chUsed;

				// Change the score
				// ================

				Worm.lScore += (*field)[pLink->nY][pLink->nX] & MASK_REST;

				PackCmdScore(i, pcCurrent);
				
				// Generate new prize
				// ==================

				GeneratePrize(pcCurrent);
				
				// Continue as with empty
				// ======================

			case MASK_EMPTY:

				// Draw the new head and add it to the chain
				// =========================================

				*(pcCurrent++)=pLink->nY;
				*(pcCurrent++)=pLink->nX;
				*(pcCurrent++)=Worm.chUsed;

				(*field)[pLink->nY][pLink->nX] = Worm.chUsed;

				Worm.pHead->pNext = pLink;
				Worm.pHead = pLink;
				break;

			case MASK_PLAYER:
			case MASK_OTHER:
			
				// Kill 'im
				// ========
				//printf("Kill at %d,%d, %c\n", pLink->nX, pLink->nY,
				//		(*field)[pLink->nY][pLink->nX]);

				MakeLifeSpent(i, pcCurrent);
			}
		}

		//printf("Wrote changes\n");

		// Write the end --- make clients refresh
		// ======================================

		*(pcCurrent++) = CHAR_COMMAND;
		*(pcCurrent++) = CHAR_REFRESH;
		*(pcCurrent++) = 0;

		for(int i = 0; i < consc; i++)
		{
			if (connections[i].sock == -1) continue;
			g_nWrite = i;
			send(connections[i].sock, szCommand, pcCurrent-szCommand, 0);
		}

		//printf("Wrote refresh\n");

		// Sleep via select
		// ================

		//timeout.tv_sec = 0;
		//timeout.tv_usec = 10;
		//select(g_nMaxDescriptorBitsToSelect, NULL, NULL, NULL, &timeout);
		
		//printf("Woke up\n");
	}
}
