#include "common.h"

class CWormClient
{
protected:
	int m_nMyId;

	inline long UnpackLong(const char* pc_c)
	{
		const unsigned char* pc_cReceived = (const unsigned char*) pc_c;
		unsigned long l = pc_cReceived[0] |
				(pc_cReceived[1] << 8) |
				(pc_cReceived[2] << 16) |
				(pc_cReceived[3] << 24);
		return l;
	}
	bool ParseArg(char* szArg, int& nPort);

	virtual void Log(const char* szString, ...);
	virtual bool Initialize() {return true;}
	virtual bool Uninitialize() {return true;}
	virtual bool OnRefresh() {return true;}
	virtual bool OnSetId() {return true;}
	virtual bool OnDeath(int nPlayer) {return true;}
	virtual bool OnDisconnect(int nPlayer) {return true;}
	virtual bool OnAte(int nPlayer) {return true;}
	virtual bool OnScore(int nPlayer, long lScore) {return true;}
	virtual bool OnLives(int nPlayer, long lLives) {return true;}
	virtual bool OnStoppedDueTo(int nPlayer) {return true;}
	virtual bool OnUnknownCommand(unsigned char ch1, unsigned char ch2, 
									int sock) {return true;}

	virtual bool OnCellEmpty(int nX, int nY) {return true;}
	virtual bool OnCellPlayer(int nX, int nY, int nPlayer) {return true;}
	virtual bool OnCellPrize(int nX, int nY, int nValue) {return true;}
	virtual bool OnCellWall(int nX, int nY) {return true;}
		
	virtual unsigned char GetInput() {return 0;}
public:
	CWormClient() {}
	enum EErrors { e_Success = 0, e_CantConnect, e_FailedInit};
	EErrors Run(char* szServer, int nPort = DEFAULT_PORT);

};

class CTimer
{
protected:
	timeval m_tv;
public:
	void CheckPoint() {gettimeofday(&m_tv);}
	long Elapsed()
	{
		timeval tv1;
		gettimeofday(&tv1);
		return (tv1.tv_sec-m_tv.tv_sec)*1000 + (tv1.tv_usec-m_tv.tv_usec)/1000;
	}
};
