extern "C" {
#include "tcpip.h"
#include <sys/file.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <fcntl.h>
#include <stdio.h>
#include <netinet/in.h>
#include <unistd.h>

#ifndef SYS5
#define gettimeofday(tv) ( gettimeofday((tv), 0) )
#endif
}

#include <string.h>
#include "rcvbytes.h"
#include "wcli.h"

bool CWormClient::ParseArg(char* szArg, int& nPort)
{
	char* p_cColon = strrchr(szArg, ':');
	if (p_cColon) {
		*p_cColon = 0;
		sscanf(p_cColon + 1, "%d", &nPort);
	}
	
	return true;
}

void CWormClient::Log(const char* szString, ...)
{
	printf(szString);
}

CWormClient::EErrors CWormClient::Run(char* szServer, int nPort)
{
	// Connect to the server
	// =====================

	Log("Connecting...\n");
	int sockServer =  ConnectTo(szServer, nPort);
	if(sockServer == -1) 
	{
		Log("Can't connect\n");
		return e_CantConnect;
	}
	Log("Connected\n");

	if(!Initialize()) return e_FailedInit;

	int nCount = 0;
	while(1)
	{
		unsigned char szBuffer[4];
		szBuffer[3] = 0;

		timeval tvTimeout;
		tvTimeout.tv_sec = 50;
		tvTimeout.tv_usec = 0;
		if(!RecvBytes(sockServer, (char*)szBuffer, 3, tvTimeout))
		{
			Log("Server quit");
			Uninitialize();
			break;
		}
		
		if(szBuffer[0] == CHAR_COMMAND)
		{
			if(szBuffer[1] == CHAR_REFRESH)
			{
				if(!OnRefresh()) break;
			}
			else if(szBuffer[1] == CHAR_YOURID)
			{
				m_nMyId = szBuffer[2];
				if(!OnSetId()) break;
			}
			else if(szBuffer[1] == CHAR_DEATH)
			{
				if(!OnDeath(szBuffer[2])) break;
			}
			else if(szBuffer[1] == CHAR_ATE)
			{
				if(!OnAte(szBuffer[2])) break;
			}
			else if(szBuffer[1] == CHAR_SCORE)
			{
				char szBuf[4];
				if(!RecvBytes(sockServer, szBuf, 4, tvTimeout))
				{
					// Server quit. Will quit later.
				}

				long lScore = UnpackLong(szBuf);
				if(!OnScore(szBuffer[2], lScore)) break;
			}
			else if(szBuffer[1] == CHAR_DISCONNECT)
			{
				if(!OnDisconnect(szBuffer[2])) break;
			}	
			else if(szBuffer[1] == CHAR_LIVES)
			{
				char szBuf[4];
				if(!RecvBytes(sockServer, szBuf, 4, tvTimeout))
				{
					// Server quit. Will quit later.
					Log("Server quit in lives\n");
				}

				long lLives = UnpackLong(szBuf);
				if(!OnLives(szBuffer[2], lLives)) break;
			}
			else if(szBuffer[1] == CHAR_REQUEST_USER_INPUT)
			{
				// Get an input character if there
				// ===============================
				
				signed char ch = GetInput();
				if(ch == -1) break;

				// Write it to the server
				// ======================
	
				send(sockServer, &ch, 1, 0);
			}
			else if (szBuffer[1] == CHAR_STOPPED_DUE_TO)
			{
				if (!OnStoppedDueTo(szBuffer[2])) break;
			}
			else
			{
				// Unknown command
				// ===============

				OnUnknownCommand(szBuffer[1], szBuffer[2], sockServer);
			}
		}
		else
		{
			// Not a command --- just a field change
			// =====================================
		
			int nY = szBuffer[0];
			int nX = szBuffer[1];

			switch(szBuffer[2] & MASK_ALL)
			{
			case MASK_EMPTY:
				OnCellEmpty(nX, nY);
				break;
			case MASK_PLAYER:
				OnCellPlayer(nX, nY, szBuffer[2] & MASK_REST);			
				break;
			case MASK_PRIZE:
				OnCellPrize(nX, nY, szBuffer[2] & MASK_REST);
				break;
			case MASK_OTHER:
				OnCellWall(nX, nY);
				break;
			}
		}
	}

	close(sockServer);
	Uninitialize();
}
