#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

#include <stdio.h>

int ConnectTo(char* szName, int nPort)
{
	struct hostent* pheRemote;
	int sockSocket;
	struct sockaddr_in sainRemote;

	pheRemote = gethostbyname(szName);
	if(pheRemote == 0) return -1;

	sockSocket = socket(PF_INET, SOCK_STREAM, 6);

	sainRemote.sin_family = AF_INET;
	sainRemote.sin_port = htons((short) nPort);
	memcpy(&(sainRemote.sin_addr.s_addr), pheRemote->h_addr, 4);

	if (connect(
			sockSocket, 
			(struct sockaddr *) &sainRemote, 
			sizeof(struct sockaddr_in))) {
		close(sockSocket);
		return -1;
	}

	return sockSocket;
}
