extern "C" {
#include <sys/file.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <fcntl.h>
#include <stdio.h>

#ifndef SYS5
#define gettimeofday(tv) ( gettimeofday((tv), 0) )
#endif
}

#include <errno.h>
#define MAX_ALLOWED_EMPTY_RECEIVES 239

static bool
RecvBytesPoll(

	int nSock,
	char* pcBuffer,
	int nBytes, 
	timeval& r_tvZeroTimeOut

) {
	int nReadSoFar = 0;

	fd_set readfds;
	FD_ZERO(&readfds);
	int nEmptyReceives = 0;
	while(nReadSoFar < nBytes)
	{
		FD_SET(nSock, &readfds);

		int nReady
			= select(nSock + 1, &readfds, NULL, NULL, &r_tvZeroTimeOut);
		if (nReady < 0)
			if (errno == EINTR)
				continue; // select() interrupted
			else
				return false;

		if (!nReady)
			return false; // timed out

		int nRes;
		if (
			(nRes = recv(nSock, pcBuffer+nReadSoFar, 1, 0))
			> 0
		) {
			nReadSoFar++;
			nEmptyReceives = 0;
		}
		else if (
			(nRes < 0 && errno && errno != EINTR)
			|| (++nEmptyReceives > MAX_ALLOWED_EMPTY_RECEIVES)
		) {
			//if (nRes < 0) perror("recv() failed in RecvBytes()");
			return false; // recv failed or too many empty receives
		}
	}

	return true;
}
	
bool 
RecvBytes(

	int nSock,
	char* pcBuffer,
	int nBytes, 
	timeval& r_tvTimeOut
	
) {
	if (!(r_tvTimeOut.tv_sec || r_tvTimeOut.tv_usec))
		return RecvBytesPoll(nSock, pcBuffer, nBytes, r_tvTimeOut);

	int nReadSoFar = 0;

	timeval tvEnd;
	gettimeofday(&tvEnd);
	// tvEnd += r_tvTimeOut
	{
		if ((tvEnd.tv_usec += r_tvTimeOut.tv_usec) > 999999) {
			tvEnd.tv_usec -= 1000000;
			tvEnd.tv_sec++;
		}
		tvEnd.tv_sec += r_tvTimeOut.tv_sec;
	}
	// Now tvEnd is the time when we must finish
	
	fd_set readfds;
	FD_ZERO(&readfds);
	bool bResult = true;
	int nEmptyReceives = 0;
	while(nReadSoFar < nBytes)
	{
		FD_SET(nSock, &readfds);

		timeval tvNow;
		gettimeofday(&tvNow);

		// timeval tvRest(tvEnd - tvNow)
		timeval tvRest(tvEnd);
		if ((tvRest.tv_usec -= tvNow.tv_usec) < 0) {
			tvRest.tv_usec += 1000000;
			tvRest.tv_sec--;
		}
		if ((tvRest.tv_sec -= tvNow.tv_sec) < 0) {
			r_tvTimeOut.tv_sec = r_tvTimeOut.tv_usec = 0;
			return RecvBytesPoll(nSock, pcBuffer, nBytes, r_tvTimeOut);
		}
	
		int nReady = select(nSock + 1, &readfds, NULL, NULL, &tvRest);
		if (nReady < 0)
			continue; // select() interrupted

		if (!nReady) {
			r_tvTimeOut.tv_sec = r_tvTimeOut.tv_usec = 0;
			return false; // timed out
		}

		int nRes;
		if (
			(nRes = recv(nSock, pcBuffer+nReadSoFar, 1, 0))
			> 0
		) {
			nReadSoFar++;
			nEmptyReceives = 0;
		}
		else if (
			(nRes < 0 && errno && errno != EINTR)
			|| (++nEmptyReceives > MAX_ALLOWED_EMPTY_RECEIVES)
		) {
			//if (nRes < 0) perror("recv() failed in RecvBytes()");
			bResult = false;
			break;
		}
	}

	// Not timed out, finished recv().
	// Decrement or zero tvTimeOut accordingly.
	timeval tvNow;
	gettimeofday(&tvNow);
	if ((r_tvTimeOut.tv_usec = (tvEnd.tv_usec - tvNow.tv_usec)) < 0) {
		r_tvTimeOut.tv_usec += 1000000;
		tvNow.tv_sec++;
	}
	if ((r_tvTimeOut.tv_sec = (tvEnd.tv_sec - tvNow.tv_sec)) < 0) {
		r_tvTimeOut.tv_sec = r_tvTimeOut.tv_usec = 0;
	}
	return bResult;
}
