#include "wcli.h"
class CWormBot : public CWormClient
{
protected:
	typedef unsigned int FIELDTYPE [ FIELD_HEIGHT ] [ FIELD_WIDTH ];
	struct CWorm
	{
		int nX, nY, nDX, nDY;
		CWorm() : nX(-1), nY(-1), nDX(0), nDY(0){}
	} m_aWorms[100];
	bool m_a_bConnectedAfter[100];
	int nLaterPlayers; // # of 'true's in m_a_bConnectedAfter
	bool bStoppedWithoutRivals;
	
	//unsigned int field[FIELD_HEIGHT][FIELD_WIDTH];
	FIELDTYPE m_field;
	CTimer m_Timer;
	unsigned char m_chMove, m_chPrevMove, m_chNextMove;
	int m_nX, m_nY, m_nDX, m_nDY, m_nTailX, m_nTailY;
	int m_nPrizeX, m_nPrizeY; 

	struct SavedPos
	{
		int nX, nY, nVal;
	} m_aChanged[5];

	class CToVisitQueue
	{
#		define MAX_QUEUE 10000
	protected:
		struct VisitPos
		{
			int nX, nY;
		} m_aToVisit[MAX_QUEUE];
		int m_nLast, m_nFirst;
		bool m_bEmpty;
	public:
		void Reset() {m_nLast = 0; m_nFirst = 1; m_bEmpty = true;}
		void AddPlace(int nX, int nY);
		bool NextPlace(int& nX, int& nY);
		void AddAllNeighbors(int j, int i);
	} m_Queue;
		

	int m_nChanged;

protected:
	void CopyField(FIELDTYPE& field1, FIELDTYPE& field2);
	int PrintUsage();
	bool IsOpposite(char ch1, char ch2);
	void PrintTrace(FIELDTYPE& field);
	void PrintProperty(FIELDTYPE& field);
	void ClearDist(FIELDTYPE& field);
	void TraceDist(FIELDTYPE& field, int nToX, int nToY, bool bPrecise = true);
	void TraceDistSet(FIELDTYPE& field, bool bPrecise);
	void CheckHead(int nX, int nY);
	void AddChange(int nX, int nY, int nVal);
	void UndoChanges();
	void PrepareMove();
	bool AssertMove(char ch);
	void Pace();
	int CountFreeNeighbors(int nX, int nY);
	void PickAnyMove();
	int PickClosestMove();
	void MapProperty(FIELDTYPE& field);
	void MapAllWorms(FIELDTYPE& fieldW);
	void MakeIntoProperty(FIELDTYPE& fieldW);
	int ComputeTerritory(FIELDTYPE& field);
protected:
	virtual bool Initialize();
	virtual bool Uninitialize();
	virtual bool OnRefresh();
	virtual bool OnDeath(int nPlayer);
	virtual bool OnStoppedDueTo(int nPlayer);
	virtual bool OnDisconnect(int nPlayer);
	virtual bool OnScore(int nPlayer, long lScore);
	virtual bool OnLives(int nPlayer, long lLives);

	virtual bool OnCellEmpty(int nX, int nY);
	virtual bool OnCellPlayer(int nX, int nY, int nPlayer);
	virtual bool OnCellPrize(int nX, int nY, int nValue);
	virtual bool OnCellWall(int nX, int nY);
		
	virtual unsigned char GetInput();
public:
	CWormBot() : m_nX(0), m_nY(0), m_nDX(0), m_nDY(0), m_nTailX(0), m_nTailY(0),		nLaterPlayers(0), bStoppedWithoutRivals(true)
	{for(int i=0; i < 100; i++) { m_a_bConnectedAfter[i] = false; } }
	void Run(int argc, char** argv);
};
