LPR=(cat -v| /usr/5bin/pr -e4 -t| enscript -h)
DISTDIR = $(shell basename $$PWD)
CVSMODULE=games/boa
#PWD = $(shell pwd | sed -e 's/\/tmp_mnt//g')
#RSH = rsh $(RHOST) chdir $(PWD) ";"
RSH=

HDRS=boabot.h common.h rcvbytes.h tcpip.h wcli.h wui.h
SRCS=boabot.cpp rcvbytes.cpp tcpip.c wcli.cpp wserver.cpp wui.cpp

CFLAGS=-fno-rtti -O3
LINK=g++ $(LINKOPTS) $(CFLAGS)

.PHONY: all
all: $(BIN) $(BIN)/boabot$(EXE) $(BIN)/boa$(EXE) $(BIN)/boaserv$(EXE)
$(BIN):
	mkdir $@

.SUFFIXES: .cpp .c $(SUFFIXES)

$(BIN)/%.o: %.cpp
		$(RSH) g++ $(BUILDOPTS) $(CFLAGS) -c $(PWD)/$< -o $(BIN)/$(<:cpp=o)
	
$(BIN)/%.o: %.c
		$(RSH) gcc $(BUILDOPTS) $(CFLAGS) -c $(PWD)/$< -o $(BIN)/$(<:c=o)
	
$(BIN)/boaserv$(EXE): $(BIN)/wserver.o $(BIN)/rcvbytes.o
	$(LINK) $^ $(RANDOM) -o $@

$(BIN)/boa$(EXE): $(BIN)/wui.o $(BIN)/wcli.o $(BIN)/tcpip.o $(BIN)/rcvbytes.o 
	$(LINK) $^ $(CURSES) $(TERMCAP) -o $@

$(BIN)/boabot$(EXE): $(BIN)/boabot.o $(BIN)/wcli.o $(BIN)/tcpip.o $(BIN)/rcvbytes.o 
	$(LINK) $^ -o $@

.PHONY: clean
clean:
	-rm *~ $(BIN)/*.o $(BIN)/boaserv$(EXE) $(BIN)/boa$(EXE) $(BIN)/boabot$(EXE)

distclean:
	-rm -rf bin* *gz

.PHONY: tar
tar:	../$(DISTDIR).tar
../$(DISTDIR).tar:	distclean
	-rm -f $@
	cd ..; tar cvf $(DISTDIR).tar $(DISTDIR)

.PHONY: bzip2
bzip2:	../$(DISTDIR).tar.bz2
../$(DISTDIR).tar.bz2: ../$(DISTDIR).tar
	-rm -f $@
	bzip2 -9 < $< > $@

.PHONY: gzip
gzip:	../$(DISTDIR).tar.gz
../$(DISTDIR).tar.gz: ../$(DISTDIR).tar
	-rm -f $@
	gzip --best < $< > $@

.PHONY: rel%
rel%:
	-rm -rf $(DISTDIR)-$*
	mkdir $(DISTDIR)-$*
	cvs export -r$@ -d $(DISTDIR)-$* $(CVSMODULE)
	tar cvf $(DISTDIR)-$*.tar $(DISTDIR)-$*
	rm -rf $(DISTDIR)-$*
	gzip --best < $(DISTDIR)-$*.tar > $(DISTDIR)-$*.tar.gz
	bzip2 -9 < $(DISTDIR)-$*.tar > $(DISTDIR)-$*.tar.bz2
	GZ_SIZE=`ls -l $(DISTDIR)-$*.tar.gz | awk '{print $$5}'`\
	BZ2_SIZE=`ls -l $(DISTDIR)-$*.tar.bz2 | awk '{print $$5}'`\
	; ( sed \
		-e 's/@REL@/$*/g' \
	-e "s/@ENTERED_DATE@/$(shell date +%d%b%y | tr '[:lower:]' '[:upper:]')/g" \
		-e "s/@GZ_SIZE@/$$GZ_SIZE/g" \
		-e "s/@BZ2_SIZE@/$$BZ2_SIZE/g" \
		boa.lsm.in > boa-$*.lsm )
	rm -f $(DISTDIR)-$*.tar

$(BIN)/boabot.o: boabot.h
$(BIN)/boabot.o $(BIN)/wserver.o $(BIN)/wui.o $(BIN)/wcli.o: common.h
$(BIN)/boabot.o $(BIN)/wserver.o $(BIN)/wui.o $(BIN)/wcli.o: rcvbytes.h
$(BIN)/boabot.o $(BIN)/wui.o $(BIN)/wcli.o: tcpip.h
$(BIN)/boabot.o $(BIN)/wui.o $(BIN)/wcli.o: wcli.h
$(BIN)/wui.o: wui.h
