// DeHackEd version 2.3
// Written by Greg Lewis, gregl@umich.edu
// If you release any versions of this code, please include
// the author in the credits.  Give credit where credit is due!


#include <sys/types.h>
#include <stdarg.h>
#include <stdio.h>

#include "dehacked.h"
#include "screen.h"

#undef TEXT
#undef WIDTH
#undef HEIGHT
#include "ttyobj.h"


void Blankwindow(char attr, int left, int top, int right, int bot)
{
	textattr(attr);
	clrbox(left, top, right-left+1, bot-top+1);
	textattr(NORMAL);
}

// Clears the screen with attr and a fill character.  Does NOT clear
// the first and last rows (status rows).

void clearscreen(char attr, char fill)
{
	int h, i;

	/* move 1,1
	   clear with attr,fill to eos-1
	*/
	gotoxy(1,2);
	textattr(attr);
	for ( h=2; h<=49; ++h ) {
		for ( i=1; i<=80; ++i )
			putch(fill);
	}
	textattr(0);
}

// Direct I/O -- puts the string at x, y, with full formatting.

void CPrintfXY(int x, int y, char *string, ...)
{
	va_list ap;
	char buffer[80];

	va_start(ap, string);
	gotoxy(x, y);
	vsprintf(buffer, string, ap);
	cputs(buffer);
	va_end(ap);
}

// Direct I/O -- puts the string at x, y.

void CPutsXY(int x, int y, char *string)
{
	gotoxy(x, y);
	cputs(string);
}

// Draw the frame for a window at the specified coordinates, with the
// specified attribute.

void Drawframe(int type, unsigned char attr, int left, int top, int right,
					int bot)
{
	unsigned cul, cur, cll, clr, chz, cvt;
	int i;

	if (type < 0 || type > 4)
		type = 0;

	textattr(attr);
	cul = (unsigned char)ul[IBM_CHARSET][type];
	cur = (unsigned char)ur[IBM_CHARSET][type];
	cll = (unsigned char)ll[IBM_CHARSET][type];
	clr = (unsigned char)lr[IBM_CHARSET][type];
	chz = (unsigned char)hz[IBM_CHARSET][type];
	cvt = (unsigned char)vt[IBM_CHARSET][type];

	pokew(left, top,  cul);
	pokew(right, top, cur);
	pokew(left, bot,  cll);
	pokew(right, bot, clr);

	for (i=left+1; i<right; i++)
	{
		pokew(i, top, chz);
		pokew(i, bot, chz);
	}

	for (i=top+1; i<bot; i++)
	{
		pokew(left,  i, cvt);
		pokew(right, i, cvt);
	}
	textattr(0);

	Blankwindow(attr, left+1, top+1, right-1, bot-1);
}

// *** Note:  These two functions should both be uncommented and inlined,
// but I couldn't figure out how.  I inlined them myself in DeHackEd.cpp
// and playview.cpp.

// Puts an attribute at
/*
extern void Putattr(unsigned char attr, int col, int row)
{
	pokeb(col-1, row-1, 1, attr);
}

// Puts a pixel of color col at x, y.

extern void putpix(unsigned int x, unsigned int y, int col)
{
	if (x <= 319 && y <= 199)
		pscreen[(y<<8)+(y<<6) + x] = col;
}*/


// Clears the screen and prints a little status bar

void WipeScreen(void)
{
	clearscreen(NHILIT, blank[IBM_CHARSET]);
	textattr(BARS);
	gotoxy(1, 1);
	cprintf(" F2 Things  F3 Frames  F4 Weapons  F5 Sounds  F6 Sprites  F7 Text  F8 Thinglist ");
	gotoxy(1, 50);
	cprintf("         F1 Help          DeHackEd v2.3 by Greg Lewis          Esc Quit         ");
	textattr(NORMAL);
}
