/* User section */

#define MAX_TANKS 20
#define MAX_WIDTH 1100
#define MAX_HEIGHT 800
#define MAX_SHOTS 50
#define MAX_COLORS 50
#define MAX_LINES 100
#define MAX_WEAPONS 50
#define TANK_LENGTH 10
#define ATT_DAMAGE 50
#define FALL_DAMAGE 40
#define PRIZE 5 /* Prize for 1 Damage point */
#define EXPLOD_INCR 3 /* Speed of explosions 1 - slowest */
#define RED_COL 64 /* How many red colors for explosions */
#define GUID_MIS_ACCEL 1 /* Accelaration of guided missile */
#define TANK_EXPLOSION_SHOTS 3 /* The number of shots a tank explosion
	generates */
#define TANK_EXPLOSION_RADIUS 50 /* How big is the tank explos shot radius */
#define TE_SHOT_YVELOC 100 /* The initial YVel of tank explosion shot */
#define TE_SHOT_MAX_XVELOC 100 /* The maximum initial XVel of te shot (it's
	random) */
#define NAME_EXPLOS "r_exp3.wav"
#define NAME_BOUNCE "bounce.wav"
#define NAME_SFIRE "grenade.wav"
#define NAME_FFIRE "sgun1.wav"

/* End user section */

#define SND_EXPLOS 0
#define SND_SFIRE 1
#define SND_FFIRE 2
#define SND_BOUNCE 3


#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <unistd.h>
#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xproto.h>
#include <X11/Intrinsic.h>
#include <soundIt.h>


struct my_colors {
	unsigned char r,g,b;
	long p;
} color[MAX_COLORS + RED_COL];

typedef struct {
	char *name;
	unsigned char type;
	int radius, price, amount_for_price, arg;
} Weapon;
Weapon weapons[MAX_WEAPONS];

typedef struct {
	char *fire, *turn_left, *turn_right, *power_up, *power_down,
	*power_f_up, *power_f_down, *change_weap;
} TKeymap;

typedef struct {
	char *name;
	unsigned char type, color, team, cur_weap, wins, control, guiding;
	int max_power, power, fire_delay, end_x, end_y, computer_type,
		text_box_place, weapon[MAX_WEAPONS];
	long money, points;
	float xvel, yvel;
	float cur_x, cur_y;
	TKeymap keys;
	double cur_angle;
	double tank_angle;
} Tank; 
Tank tanks[MAX_TANKS];


typedef struct {
	int type, radius, owner, explode, locked, arg, target;
	double XVel, YVel, x, y;
} Shot;
Shot shots[MAX_SHOTS];

extern int FindNextWeapon();
extern void BuyMode();
extern void DrawTank(int tank, int color, int);
extern void DrawLandscape();
extern void CreateLandscape();
extern void DrawLandscapeInBattlefield();
extern int CheckForLife();
extern void BeginNewMatch();
extern void BatDrawLine(int x1, int x2, int y1, int y2, int color, int, int);
extern void EndMatch(int winner);
extern void ReadConfigFile(char *file);	
extern double DegToRad(double degrees);
extern double RadToDeg(double radians);
extern void InitSound();
extern int CalcDistance (int x1, int x2, int y1, int y2);
extern void ExplodeShot (int shot_number);
extern void UpdateShots ();
extern void QueryShot(int tank);
extern void DrawBattlefieldArc(int x, int y, int rx, int ry, int angstart, int,
        int color, int changedby, int realcolor);
extern void CalculateShot(int tank);
extern int EarthFall(int begin, int end);
extern int TankFall();
extern void ExplodeTank(int tank);
extern void DrawTanksInBattlefield();

unsigned char number_of_tanks, red_begin, battletime, topeffect, lefteffect,
	righteffect, bottomeffect, landscape_change, buy_mode, cur_select,
	sound;
int num_shots, wind, max_wind, fall_damage, fall_aspeed;
float air_resist, lands_change;
float gravity, nat_delay;
int width, height, fall_delay, fall_delay_counter, wind_text_reserve;
int landscape[MAX_WIDTH], firing_delay, one_shot, depth, curchan;
unsigned char tank_in_turn, simultmode;
int keys[1024];
Sample snd[10];

Display *dpy;
GC gc, Textgc;
XFontStruct *playfont;
XColor          XColors[MAX_COLORS + RED_COL];
Window mainwind, textwind;

typedef struct {
	unsigned char hpoint[MAX_HEIGHT];
	unsigned char changed, changer;
	} Vline;
Vline vline[MAX_WIDTH];
#define PLAY_FONT "-adobe-times-*-*-*-*-14-*"
