/*    XAttack - a poor game :)
*     Copyright (C) 1998  Andrius Glozheckas
*     
*     This program is free software; you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation; either version 2 of the License, or
*     (at your option) any later version.
*     
*     This program is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*     
*     You should have received a copy of the GNU General Public License
*     along with this program; if not, write to the Free Software
*     Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*
*     You can contact the author at aces@softhome.net, aces@hempseed.com.
*/

#include "xattack.h"


unsigned long get_color(int n);
void allocate_colors(), ClearBattlefield();
void microsleep(unsigned long usec);
int is_key_pressed(char *key);
void Process_keys();
void DrawText();
/* int x, y, startx, starty, length;   */
double angled = 45;
Colormap cmap;
int key_count;                                                                                                        

main (argc, argv)
int argc;
char *argv[];
{
	Widget toplevel;
	Window top;
	XGCValues xgc;
	XtAppContext app;
	XEvent event;
	int n, i, depth, screen, one_shot_check;
	int black, white;
	char *current_key, *tmp;

	curchan = 0;	
	buy_mode = 0;
        weapons[0].type = 1;
        weapons[0].name = "Tracer";
        weapons[0].radius = 1;                
	ReadConfigFile("defaults");
	if (argc > 1) ReadConfigFile(argv[1]);	
	toplevel = XtAppInitialize(&app, "XAttack",
		NULL, 0, &argc, argv, NULL, NULL, 0);
	dpy = XtDisplay(toplevel);
	top = XCreateSimpleWindow(dpy, RootWindow(dpy,0), 0, 0,
		width, height + 20, 0, 0, XColors[0].pixel);
	textwind = XCreateSimpleWindow(dpy, top, 0, 0,
		width, height, 1, XColors[0].pixel, XColors[0].pixel);
	mainwind = XCreateSimpleWindow(dpy, top, 0, 20,
		width, height - 20, 0, 0, XColors[0].pixel);
	if ((playfont = XLoadQueryFont(dpy, PLAY_FONT)) == NULL) perror("Cannot load font");
	XMapWindow(dpy, mainwind);
	XMapWindow(dpy, textwind);
	XMapWindow(dpy, top);
	tmp = (char *) malloc(100);
	sprintf(tmp, "Wind: -%d", max_wind);
	wind_text_reserve = width - XTextWidth(playfont, tmp, strlen(tmp));
	cmap = DefaultColormap(dpy, DefaultScreen(dpy));
        allocate_colors();
	screen = DefaultScreen(dpy);
        depth = DefaultDepth(dpy,screen);
	gc = XCreateGC(dpy, mainwind, 0, &xgc);
	Textgc = XCreateGC(dpy, textwind, 0, &xgc);
	XSetFont(dpy, Textgc, playfont->fid);
	XSetFont(dpy, gc, playfont->fid);
	black = BlackPixel(dpy, DefaultScreen(dpy));
	white = WhitePixel(dpy, DefaultScreen(dpy));
	depth = DefaultDepth(dpy,screen);
	XSetBackground(dpy, gc, XColors[0].pixel);
	XSetBackground(dpy, Textgc, XColors[0].pixel);
	BeginNewMatch();
	XSelectInput(dpy, mainwind, KeyPressMask | KeyReleaseMask | ExposureMask);	
	XSelectInput(dpy, textwind, KeyPressMask | KeyReleaseMask);	
	XSelectInput(dpy, top, KeyPressMask | KeyReleaseMask);	
	XFlush(dpy);
	XSync(dpy, True);
	DrawText();
	if (sound) InitSound();
	XAutoRepeatOff(dpy);
	key_count = 0;
	while(1) {
                if ( simultmode)
                {
/*                        for(i = 0; i < number_of_tanks; i++) {
                                one_shot_check = 0;
                                if (tanks[i].fire_delay > 0)
                                        tanks[i].fire_delay--;
                                else
                                        if (tanks[i].computer_type != 0)
                                        {
                                                if (one_shot > 0)
                                                {
                                                for(n = 1; n < num_shots; n++)
                                                        if ((shots[n].type != 0) && (shots[n].owner == i))
                                                                {
                                                                one_shot_check = 1;
                                                                }
                                                }
                                        if (!one_shot_check)
                                                CalculateShot(i);
                                        }
                        } */
                }

		if (XCheckTypedEvent(dpy, KeyPress, &event)) {
			keys[XKeysymToKeycode(dpy, XLookupKeysym(&event.xkey, 0))] = 1;
			}
		if (XCheckTypedEvent(dpy, KeyRelease, &event)) {
			keys[XKeysymToKeycode(dpy, XLookupKeysym(&event.xkey, 0))] = 0;
			}
		if (key_count > 0) key_count--;
		else {
			Process_keys();
			key_count = 4;
		}
		if (XCheckTypedEvent(dpy, Expose, &event)) {
			if (!buy_mode) {
			DrawLandscape();
			DrawText();
			for (n = 0; n < number_of_tanks; n++) {
				if (tanks[n].max_power > 0)
					DrawTank(n, tanks[n].color, 2);
					else
					DrawTank(n, 9, 2);
				}
			} else {
			PaintMenu();
			}
			while(XCheckTypedEvent(dpy, Expose, &event));
			}

		if (buy_mode) usleep(10000);
		if (!buy_mode) {
                for(i = 0; i < number_of_tanks; i++)
		{
                        if (tanks[i].guiding != 0)
                        {
                                shots[tanks[i].guiding].arg--;
                                tank_in_turn = i;
                                DrawText();
                                if (shots[tanks[i].guiding].arg < 0)
                                {
                                        ExplodeShot(tanks[i].guiding);
                                        tanks[i].guiding = 0;
                                        DrawText();
                                }
                        }
                }
			if (battletime || simultmode) {
				usleep(1);
				
				UpdateShots();
				}
			CheckForLife();
		}
	}
}

int CheckForLife()
{
        int tmp_team, i;
        tmp_team = -1;
        for(i = 0; i < number_of_tanks; i++) {
                if ((tanks[i].max_power > 0) && (tmp_team == -1))
                        tmp_team = tanks[i].team;
                if ((tanks[i].max_power > 0) && (tmp_team !=
                        tanks[i].team)) tmp_team = -2;
        }
        for(i = 1; i < num_shots; i++) {
                if (shots[i].type != 0)
                        tmp_team = -2;
        }
        if (tmp_team == -1)
        {
                EndMatch(-1);
                return 0;
        }
        else if (tmp_team != -2) EndMatch(tmp_team);
        return 1;
}
int BatTraceLine(x1, x2, y1, y2) {
        int i, tmpc;

        if ((x2 - x1 == 0) && (y2 - y1 == 0))
        {
                if (vline[x1].hpoint[y1] != 0)
                        return vline[x1].hpoint[y1];
        }
        if (x2 - x1 > y2 - y1)
        {
                if (x2 > x1)
                for(i = x1; i < x2; i++) {
                        tmpc = ((y2 - y1) * (i - x1) / (x2 - x1)) + y1;
                        if (vline[i].hpoint[tmpc] != 0)
                                return vline[i].hpoint[tmpc];
                }
                if (x2 < x1)
                for(i = x1; i > x2; i--) {
                        tmpc = ((y2 - y1) * (i - x1) / (x2 - x1)) + y1;
                        if (vline[i].hpoint[tmpc] != 0)
                                return vline[i].hpoint[tmpc];
                }
        } else {
                if (y2 > y1)
                for(i = y1; i < y2; i++) {
                        tmpc = ((x2 - x1) * (i - y1) / (y2 - y1)) + x1;
                        if (vline[tmpc].hpoint[i] != 0)
                                return vline[tmpc].hpoint[i];
                }
                if (y2 < y1)
                for(i = y1; i > y2; i--) {
                        tmpc = ((x2 - x1) * (i - y1) / (y2 - y1)) + x1;
                        if (vline[tmpc].hpoint[i] != 0)
                                return vline[tmpc].hpoint[i];
                }

        }
}

void BatDrawLine(x1, x2, y1, y2, fcolor, changedby, gcolor) {
        int i, tmpc;

	XSetForeground(dpy, gc, XColors[gcolor].pixel);
        if ((x2 - x1 == 0) && (y2 - y1 == 0))
        {
                vline[x1].hpoint[y1] = fcolor;
                XDrawPoint(dpy, mainwind, gc, x1, y1);
        }
/*        if (x2 - x1 > y2 - y1)
        {

                if (x2 > x1)
                for(i = x1; i < x2; i++) {
                        tmpc = ((y2 - y1) * (i - x1) / (x2 - x1)) + y1;
                        vline[i].hpoint[tmpc] = fcolor;
                        XDrawPoint(dpy, mainwind, gc, i, tmpc);
                        if (changedby != -1) vline[i].changer = changedby;
                        vline[i].changed = 1;
                }
                if (x2 < x1)
                for(i = x1; i > x2; i--) {
                        tmpc = ((y2 - y1) * (i - x1) / (x2 - x1)) + y1;
                        vline[i].hpoint[tmpc] = fcolor;
                        XDrawPoint(dpy, mainwind, gc, i, tmpc);
                        if (changedby != -1) vline[i].changer = changedby;
                        vline[i].changed = 1;
                }
        } else {
                if (y2 > y1)
                for(i = y1; i < y2; i++) {
                        tmpc = ((x2 - x1) * (i - y1) / (y2 - y1)) + x1;
                        vline[tmpc].hpoint[i] = fcolor;
                        XDrawPoint(dpy, mainwind, gc, tmpc, i);
                        if (changedby != -1) vline[tmpc].changer = changedby;
                        vline[tmpc].changed = 1;
                }
                if (y2 < y1)
                for(i = y1; i > y2; i--) {
                        tmpc = ((x2 - x1) * (i - y1) / (y2 - y1)) + x1;
                        vline[tmpc].hpoint[i] = fcolor;
                        XDrawPoint(dpy, mainwind, gc, tmpc, i);
                        if (changedby != -1) vline[tmpc].changer = changedby;
                        vline[tmpc].changed = 1;
                }

        } */
}

void DrawBattlefieldArc(x, y, rx, ry, angstart, angend, bcolor, changedby, gcolor)
int rx, ry, x, y, angstart, angend, bcolor, changedby, gcolor;
{
        int circledat, n, i, curquad, radius, tmp, begquad, endquad, begx, begy, endx, endy;

	XSetForeground(dpy, gc, XColors[gcolor].pixel);
        radius = (rx + 2);
        angstart = angstart / 10;
        angend = angend / 10;
        if (angstart < 0) angstart = 360 + angstart;
        if (angstart > 360) angstart = angstart - 360;
        if (angend < 0) angend = 360 + angend;
        if (angend > 360) angend = angend - 360;
        if (angstart == 0) begquad = 0;
        if ((angstart > 0) && (angstart <= 90)) begquad = 1;
        else if ((angstart > 90) && (angstart <= 180)) begquad = 2;
        else if ((angstart > 180) && (angstart <= 270)) begquad = 3;
        else if ((angstart > 270) && (angstart <= 360)) begquad = 0;
        if (angend == 0) endquad = 4;
        if ((angend > 0) && (angend <= 90)) endquad = 4;
        else if ((angend >= 90) && (angend < 180)) endquad = 1;
        else if ((angend >= 180) && (angend < 270)) endquad = 2;
        else if ((angend >= 270) && (angend < 360)) endquad = 3;
        for(curquad = begquad; curquad < endquad; curquad++) {
        if (curquad == 4)
        {
                curquad = 0;
                if (endquad == 0)
                        return;
        }
        if ((curquad == 0) || (curquad == 2)) begx = -1 * radius;
                else begx = 0;
        if ((curquad == 1) || (curquad == 3)) endx = radius;
                else endx = 0;
        if ((curquad == 0) || (curquad == 1)) begy = -1;
                else begy = 0;
        if ((curquad == 2) || (curquad == 3)) endy = 1;
                else endy = 0;
        for(n = begx; n < endx; n++) {
                circledat = sqrt((radius * radius) - (n * n));
                for(i = begy * circledat; i < endy * circledat; i++) {
                        if (((x + n) > 0) && ((y + i) > 0)) {
                                if ((changedby != -1) && (bcolor != 2)) {
                                        vline[x + n].changed = 1;
                                        vline[x + n].changer = changedby;
                                }
 				XDrawPoint(dpy, mainwind, gc, x+n, y+i);
                                vline[x + n].hpoint[y + i] = bcolor;
                                }
                        }
        }
        }
}


void ClearBattlefield()
{
	int i, n;
	for(i = 0; i < width; i++) {
		for(n = 0; n < height; n++) {
			vline[i].changed = 0;
			vline[i].hpoint[n] = 0;
                        vline[i].changer = MAX_TANKS;
 			}
		}
}

int is_key_pressed(char *key)
{
	return keys[XKeysymToKeycode(dpy, XStringToKeysym(key))];

}

void Process_keys()
{
	char *key;
	int i;
	
	if (buy_mode) {
		if (is_key_pressed("Up")) {
			XSetForeground(dpy, gc, XColors[1].pixel);
			if (cur_select > 0)
			XDrawString(dpy, mainwind, gc, 20, 20 * (cur_select +
				1), weapons[cur_select].name,
				strlen(weapons[cur_select].name));
			cur_select--;
			if (cur_select == 0) cur_select = 1;
			XSetForeground(dpy, gc, XColors[10].pixel);
			XDrawString(dpy, mainwind, gc, 20, 20 * (cur_select +
				1), weapons[cur_select].name,
				strlen(weapons[cur_select].name));		
		}
		if (is_key_pressed("Down")) {
			XSetForeground(dpy, gc, XColors[1].pixel);
			if (cur_select > 0)
			XDrawString(dpy, mainwind, gc, 20, 20 * (cur_select +
				1), weapons[cur_select].name,				strlen(weapons[cur_select].name));
			cur_select++;
			if (weapons[cur_select].type == 0) cur_select = 1;
			XSetForeground(dpy, gc, XColors[10].pixel);
			XDrawString(dpy, mainwind, gc, 20, 20 * (cur_select +
				1), weapons[cur_select].name,
				strlen(weapons[cur_select].name));
		}
		if (is_key_pressed("space")) {
			if (tanks[tank_in_turn].money >= weapons[cur_select].price) {
				tanks[tank_in_turn].money -= weapons[cur_select].price;
			        tanks[tank_in_turn].weapon[cur_select] +=
			        	weapons[cur_select].amount_for_price;
			        }
			PaintMenu();
			}
		if (is_key_pressed("Return")) {
			tank_in_turn++;
			if (tank_in_turn == number_of_tanks) {
				tank_in_turn = 0;
				buy_mode = 0;
				BeginNewMatch();
				}
			else PaintMenu();
			}
	return;
	}
	if (simultmode) {
		for(i = 0; i < number_of_tanks; i++) {
			if (tanks[i].computer_type == 0)
			{
			if (is_key_pressed(tanks[i].keys.fire)) {
				tank_in_turn = i;
                                if (tanks[i].guiding > 0)
                                {
                                        tanks[i].guiding = 0;
                                        ExplodeShot(tanks[i].guiding);
                                } else
				QueryShot(i);
				}
			if (is_key_pressed(tanks[i].keys.turn_right)) {
				tank_in_turn = i;
				if (tanks[i].guiding > 0)
				{
                                        shots[tanks[i].guiding].XVel += 20;
				} else {
				DrawTank(tank_in_turn, 0, 0);
				if (tanks[tank_in_turn].cur_angle < 270)
					tanks[tank_in_turn].cur_angle++;
				else	tanks[tank_in_turn].cur_angle = 90;
				DrawText();
				DrawTank(tank_in_turn, tanks[tank_in_turn].color, 2);
				}
				}
			if (is_key_pressed(tanks[i].keys.turn_left)) {
				tank_in_turn = i;
                                if (tanks[i].guiding > 0)
                                {
                                        shots[tanks[i].guiding].XVel -= 20;
                                } else {
				DrawTank(tank_in_turn, 0, 0);
				if (tanks[tank_in_turn].cur_angle > 90)
					tanks[tank_in_turn].cur_angle--;
				else	tanks[tank_in_turn].cur_angle = 270;
				DrawText();
				DrawTank(tank_in_turn,
					tanks[tank_in_turn].color, 2);
				}
				}
			if (is_key_pressed(tanks[i].keys.power_up)) {
				tank_in_turn = i;
                               if (tanks[i].guiding > 0)
                                {
                                        shots[tanks[i].guiding].YVel += 20;
                                } else {
				if (tanks[tank_in_turn].power <
					tanks[tank_in_turn].max_power)
				tanks[tank_in_turn].power++;
				DrawText();
				}
			}
			if (is_key_pressed(tanks[i].keys.power_down)) {
				tank_in_turn = i;
                               if (tanks[i].guiding > 0)
                                {
                                        shots[tanks[i].guiding].YVel -= 20;
                                } else {
				if (tanks[tank_in_turn].power > 0)
				tanks[tank_in_turn].power--;
				DrawText();
				}
				}
			if (is_key_pressed(tanks[i].keys.power_f_up)) {
				tank_in_turn = i;
 				if (tanks[tank_in_turn].power < (tanks[tank_in_turn].max_power - 24))
					tanks[tank_in_turn].power += 25;
				else
					tanks[tank_in_turn].power = tanks[tank_in_turn].max_power;
				DrawText();
				}
			if (is_key_pressed(tanks[i].keys.power_f_down)) {
				tank_in_turn = i;
				if (tanks[tank_in_turn].power > 24)
					tanks[tank_in_turn].power -= 25;
				else
					tanks[tank_in_turn].power = 0;
				DrawText();
				}
                        if (is_key_pressed(tanks[i].keys.change_weap)) {
				tank_in_turn = i;
				FindNextWeapon();
			}
			}

		}
		
	if (is_key_pressed("Escape")) {
		printf("Result:\n");
		for (i = 0; i < number_of_tanks; i++) {
			printf("Tank: %s Wins: %i Points: %li\n", tanks[i].name, tanks[i].wins,
				tanks[i].points);
			}
		XAutoRepeatOn(dpy);
		exit(1);		
		}
	if (!simultmode && !battletime) {
		if (is_key_pressed("return")) {
			FindNextWeapon();
			}
		if (is_key_pressed("Right")) {
			DrawTank(tank_in_turn, 0, 0);
			if (tanks[tank_in_turn].cur_angle < 270)
				tanks[tank_in_turn].cur_angle++;
			else	tanks[tank_in_turn].cur_angle = 90;
			DrawText();

			DrawTank(tank_in_turn, tanks[tank_in_turn].color, 2);
		}

	if (is_key_pressed("Up")) {
		if (tanks[tank_in_turn].power < tanks[tank_in_turn].max_power)
			tanks[tank_in_turn].power++;
		DrawText();
		}
	if (is_key_pressed("Next")) {
		if (tanks[tank_in_turn].power > 24)
			tanks[tank_in_turn].power -= 25;
		DrawText();
		}
	if (is_key_pressed("Prior")) {
		if (tanks[tank_in_turn].power < (tanks[tank_in_turn].max_power - 24))
			tanks[tank_in_turn].power += 25;
		else
			tanks[tank_in_turn].power == tanks[tank_in_turn].max_power;
		DrawText();
		}
	if (is_key_pressed("Down")) {
		if (tanks[tank_in_turn].power > 0)
			tanks[tank_in_turn].power--;
		DrawText();
		}
	if (is_key_pressed("space")) {
		QueryShot(tank_in_turn);
		DrawText();
		}

	if (is_key_pressed("Left")) {
		DrawTank(tank_in_turn, 0, 0);
		if (tanks[tank_in_turn].cur_angle > 90)
			tanks[tank_in_turn].cur_angle--;
		else	tanks[tank_in_turn].cur_angle = 270;

		DrawText();
		DrawTank(tank_in_turn, tanks[tank_in_turn].color, 2);
		}
	if (is_key_pressed("Tab")) {
		tank_in_turn++;
		}
	if (is_key_pressed("q")) {
		tank_in_turn--;
		}
	}
}
}

int FindNextWeapon() {
	tanks[tank_in_turn].cur_weap++;
	while((tanks[tank_in_turn].weapon[tanks[tank_in_turn].cur_weap] == 0) &&                (weapons[tanks[tank_in_turn].cur_weap].type != 0))
		tanks[tank_in_turn].cur_weap++;
	if (weapons[tanks[tank_in_turn].cur_weap].type == 0) {
		tanks[tank_in_turn].cur_weap = 0;
		DrawText();
		return 0;
	}
	DrawText();
	return 1;
}


void DrawText ()
{
	char *string, *direction;
	double written_angle;
	int end;
	
	string = (char *) malloc(500);
        if (tanks[tank_in_turn].computer_type != 0) return;
        if (tanks[tank_in_turn].guiding != 0)
        {
                if (tank_in_turn == (number_of_tanks - 1))
                        end = wind_text_reserve;
                        else
                        end = tanks[tank_in_turn + 1].text_box_place;
                sprintf(string, "TTL: %i", shots[tanks[tank_in_turn].guiding].arg);
		XSetForeground(dpy, Textgc, XColors[0].pixel);
		XFillRectangle(dpy, textwind, Textgc, tanks[tank_in_turn].text_box_place, end, 0, 25);
		XSetForeground(dpy, Textgc, XColors[tanks[tank_in_turn].color].pixel);
		XDrawString(dpy, textwind, Textgc, 10, 10, string, strlen(string));
		return;
	}
			
	if (tanks[tank_in_turn].cur_angle == 180) {
		written_angle = 90.0;
		direction = "|";
		}
	else if (tanks[tank_in_turn].cur_angle > 180) {
		written_angle = 90 - (tanks[tank_in_turn].cur_angle - 180);
		direction = ">";
		}
	else {
		written_angle = tanks[tank_in_turn].cur_angle - 90;
		direction = "<";
		}
	if (simultmode) {
		sprintf(string, "P%i A: %i %s P: %i %s: %d", 
                tank_in_turn, (int) written_angle, direction,
                tanks[tank_in_turn].power, weapons[tanks[tank_in_turn].cur_weap].name,
                tanks[tank_in_turn].weapon[tanks[tank_in_turn].cur_weap]);
                if (tank_in_turn == (number_of_tanks - 1))
                        end = wind_text_reserve;
                        else
                        end = tanks[tank_in_turn + 1].text_box_place;
		XSetForeground(dpy, Textgc, XColors[tanks[tank_in_turn].color].pixel);
		XClearArea(dpy, textwind, tanks[tank_in_turn].text_box_place, 0, end - tanks[tank_in_turn].text_box_place, 25, False);
		XDrawString(dpy, textwind, Textgc, tanks[tank_in_turn].text_box_place, 10, string, strlen(string));
	} else {
	sprintf(string, "Player: %s Angle: %g %s Power: %i %s: %d",
		tanks[tank_in_turn].name, written_angle, direction,
		tanks[tank_in_turn].power,
		weapons[tanks[tank_in_turn].cur_weap].name,
		tanks[tank_in_turn].weapon[tanks[tank_in_turn].cur_weap]); 
	XSetForeground(dpy, Textgc, XColors[tanks[tank_in_turn].color].pixel);
	XClearArea(dpy, textwind, 0, 0, wind_text_reserve, 20, False);
	XDrawString(dpy, textwind, Textgc, 10, 10, string, strlen(string));
	}
}




unsigned long get_color(int n)
{
        return color[n].p;
}


/* Set up colors for color screens */
void allocate_colors()
{
        int n;

	red_begin = MAX_COLORS;
	for(n = 0; n < RED_COL; n++) {
		color[n + red_begin].r = (256 / RED_COL) * n;
		color[n + red_begin].g = 0;
		color[n + red_begin].b = 0;
		}
        for(n=0; n < sizeof(color)/sizeof(struct my_colors); n++)
        {
	        XColors[n].flags = DoRed | DoGreen | DoBlue;
        	XColors[n].pad = 0;
                XColors[n].red = color[n].r << 8;
                XColors[n].green = color[n].g << 8;
                XColors[n].blue = color[n].b << 8;
                XAllocColor(dpy, cmap, &XColors[n]);
                color[n].p = XColors[n].pixel;
        } 
}
