/*    XAttack - a poor game :)
*     Copyright (C) 1998  Andrius Glozheckas
*     
*     This program is free software; you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation; either version 2 of the License, or
*     (at your option) any later version.
*     
*     This program is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*     
*     You should have received a copy of the GNU General Public License
*     along with this program; if not, write to the Free Software
*     Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*
*     You can contact the author at aces@softhome.net, aces@hempseed.com.
*/

#include "xattack.h"

int TankFall()
{
	int i, landscape_changed = 0, cury, norepaint = 0;
	int tmp_convert1, tmp_convert2;

	for(i = 0; i < number_of_tanks; i++) {
	tmp_convert1 = tanks[i].cur_x;
	tmp_convert2 = tanks[i].cur_y;
	if ((tanks[i].cur_y < height - 2) && (vline[tmp_convert1].hpoint[tmp_convert2 + 1] == 0))
	{
		tanks[i].yvel += fall_aspeed * nat_delay;
		landscape_changed = 1;
		cury = tanks[i].cur_y;
		if (cury == (int) (tanks[i].cur_y + (tanks[i].yvel * nat_delay)))
			norepaint = 1;
		if (!norepaint) DrawTank(i, 0, 0);
		tanks[i].cur_y += tanks[i].yvel * nat_delay;
		if (tanks[i].max_power > 0)
		{
			if (!norepaint) DrawTank(i, tanks[i].color, 2);
			tanks[vline[i].changer].money += tanks[i].yvel * fall_damage * PRIZE;
			tanks[vline[i].changer].points += tanks[i].yvel * fall_damage * PRIZE;
		} else {
			if (!norepaint) DrawTank(i, 9, 2);
		}

	} else if (tanks[i].yvel > 0) {
		landscape_changed = 1;
		DrawTank(i, 0, 0);
		if (tanks[i].max_power > 0)
		{
			tanks[i].max_power -= tanks[i].yvel * fall_damage;
			if (tanks[i].max_power <= 0) ExplodeTank(i);
			if (tanks[i].power > tanks[i].max_power) tanks[i].power =
				tanks[i].max_power;
			tanks[vline[i].changer].money += tanks[i].yvel * fall_damage * PRIZE;
			tanks[vline[i].changer].points += tanks[i].yvel * fall_damage * PRIZE;
			if (tanks[i].max_power > 0) DrawTank(i, tanks[i].color, 2);
				else DrawTank(i, 8, 2);
		} else {
			DrawTank(i, 8, 2);
		}
		tanks[i].yvel = 0;
	}
	}
	 return landscape_changed;
}

void DrawTank(tank_number, colorn, colorb)
int tank_number, colorn, colorb;
{
	double angler;
	int x_calc, y_calc;

	angler = DegToRad(tanks[tank_number].tank_angle + tanks[tank_number].cur_angle);
	x_calc = (TANK_LENGTH * cos(angler)) + tanks[tank_number].cur_x;
	y_calc = (TANK_LENGTH * sin(angler)) + tanks[tank_number].cur_y;
	XSetForeground(dpy, gc, XColors[colorn].pixel);
	XDrawLine(dpy, mainwind, gc, tanks[tank_number].cur_x, tanks[tank_number].cur_y, x_calc, y_calc);
	BatDrawLine(tanks[tank_number].cur_x, x_calc, tanks[tank_number].cur_y, y_calc, colorb, MAX_TANKS, colorn);
	tanks[tank_number].end_x = x_calc;
	tanks[tank_number].end_y = y_calc;
	XSetForeground(dpy, gc, XColors[colorn].pixel);
	XFillArc(dpy, mainwind, gc, tanks[tank_number].cur_x, tanks[tank_number].cur_y,
	TANK_LENGTH / 2, TANK_LENGTH / 2, 10 * tanks[tank_number].tank_angle, (10 * tanks[tank_number].tank_angle) + 1800);
	DrawBattlefieldArc(tanks[tank_number].cur_x, tanks[tank_number].cur_y,
		TANK_LENGTH / 2, TANK_LENGTH / 2, tanks[tank_number].tank_angle * 10, (10 * tanks[tank_number].tank_angle) + 1800, colorb, -1, colorn);
}

void ExplodeTank(int tank_number)
{
	int i, cur_shot = -1, n;

	tanks[tank_number].max_power = 0;
	srand(time(0));
	for(n = 0; n < TANK_EXPLOSION_SHOTS; n++) {
		for(i = 1; (i < MAX_SHOTS) && (cur_shot == -1); i++) {
			if (shots[i].type == 0) {
				cur_shot = i;
				if (i + 1 > num_shots) num_shots = i + 1;
				}
			}
		shots[cur_shot].type = 1;
		shots[cur_shot].radius = TANK_EXPLOSION_RADIUS;
		shots[cur_shot].explode = 0;
		shots[cur_shot].owner = tank_number;
		shots[cur_shot].XVel = 0.3 * ((rand() / (RAND_MAX / (2 *
			TE_SHOT_MAX_XVELOC))) - TE_SHOT_MAX_XVELOC);
		shots[cur_shot].YVel = 0.3 * TE_SHOT_YVELOC;
		shots[cur_shot].x = tanks[tank_number].cur_x;
		shots[cur_shot].y = tanks[tank_number].cur_y - TANK_LENGTH - 1;
		cur_shot = -1;
		}
}

void DrawTanksInBattlefield()
{
	int n;

	for(n = 0; n < number_of_tanks; n++) {
		DrawBattlefieldArc(tanks[n].cur_x, tanks[n].cur_y,
			TANK_LENGTH / 2, TANK_LENGTH / 2, tanks[n].tank_angle * 10, (10 * tanks[n].tank_angle) + 1800, 2, -1, tanks[n].color);
		}

}
