/*    XAttack - a poor game :)
*     Copyright (C) 1998  Andrius Glozheckas
*     
*     This program is free software; you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation; either version 2 of the License, or
*     (at your option) any later version.
*     
*     This program is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*     
*     You should have received a copy of the GNU General Public License
*     along with this program; if not, write to the Free Software
*     Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*
*     You can contact the author at aces@softhome.net, aces@hempseed.com.
*/#include "xattack.h"

double FindAnglets(int from, int to);
int FindSmallestDistances(int from);


double FindAnglets(int from, int to)
{
        double x, y;

        x = tanks[to].cur_x - shots[from].x;
        y = tanks[to].cur_y - shots[from].y;
        if ((x > 0) && (y > 0))
        {
                return(atan(y / x));
        } else if ((x > 0.0) && (y < 0))
        {
                return(atan((y * -1) / x) + (PI / 2));
        } else if (x == 0.0)
        {
                if (y < 0) return 0;
                if (y == 0) return 0;
                if (y > 0) return PI;
        } else if ((x < 0) && (y > 0)) {
                return(atan(y / (x * -1)) + (PI * 1.5));
        } else if ((x < 0) && (y < 0)) {
                return(atan((y * -1) / (x * -1)) + PI);
        }
        return 0;
}

int FindSmallestDistances(from)
int from;
{
        int tmp_distance, smallest_distance, target_tank, i;

        smallest_distance = 32000;
        target_tank = -1;
        for(i = 0; i < number_of_tanks; i++)
        {
            if ((tanks[from].team != tanks[i].team) && (tanks[i].max_power > 0)) {
                tmp_distance = CalcDistance(shots[from].x, tanks[i].cur_x,
                    shots[from].y, tanks[i].cur_y);
                if (tmp_distance < smallest_distance) {
                    smallest_distance = tmp_distance;
                    target_tank = i;
                    }
                }
            }
        return target_tank;
}

void ExplodeShot (int shot_number)
{
	int i, t, n, tmp_length, tmp;
	int curcolor;
	float fltmp, m;
	
	i = shot_number;
        if (shots[i].type == 5) tanks[shots[i].owner].guiding = 0;
	shots[shot_number].explode += EXPLOD_INCR;
	for (t = 0; t < EXPLOD_INCR; t++) {
		m = shots[i].radius;
		fltmp = m / RED_COL;
		curcolor = red_begin + RED_COL - ((shots[i].explode - t) / fltmp
			);
		XSetForeground(dpy, gc, XColors[curcolor].pixel);
		XDrawArc(dpy, mainwind, gc, shots[i].x - (shots[i].explode -t - 1) /
		2, shots[i].y - (shots[i].explode - t - 1) / 2, shots[i].explode -
		t, shots[i].explode - t, 0, 23040);
		} 
	if (shots[i].explode > shots[i].radius) {
		for(n = 0; n < number_of_tanks; n++) {
			if (tanks[n].max_power > 0) {
				tmp_length = CalcDistance(shots[i].x,
					tanks[n].cur_x, shots[i].y,
					tanks[n].cur_y); /* */
				if (tmp_length < (shots[i].radius / 2)) {
					tmp = ((shots[i].radius / 2)
						- tmp_length) * ATT_DAMAGE;
					tanks[n].max_power = tanks[n].max_power
						- tmp;
					if (tanks[n].max_power < tanks[n].power)
						if (tanks[n].max_power > 0)
							tanks[n].power =
							tanks[n].max_power;
							else
							tanks[n].power = 0;
					if (tanks[n].max_power > 0) {
						tanks[shots[i].owner].points +=
							tmp * PRIZE;
						tanks[shots[i].owner].money +=
							tmp * PRIZE;
						}
						else {
						tanks[shots[i].owner].points +=
						(tmp + tanks[n].max_power) *
							PRIZE;
						tanks[shots[i].owner].money +=
						(tmp + tanks[n].max_power) *
							PRIZE;
						}
					}
				if (tanks[n].max_power <= 0) {
					ExplodeTank(n);
					DrawTank(n, 9, 2);
					}
				}
			}
		shots[i].type = 0;
		DrawBattlefieldArc(shots[i].x, shots[i].y,
		shots[i].explode / 2, shots[i].explode / 2, 0, 0, 0, shots[i].owner, 0);
		for(n = 0; n < number_of_tanks; n++)
			if (tanks[n].max_power > 0)
				DrawTank(n, tanks[n].color, 2);
				else
				DrawTank(n, 9, 2);

		if ((i + 1) == num_shots) num_shots--;

		}
}

void UpdateShots ()
{
	int i, conv_tmp, conv_tmp2, t, curcolor, n, tmp_length,
		tmp_team, landscape_changed, tmp_dd, tmp, tmp1;
	battletime = 0;
	
	for(i = 1; i < num_shots; i++)
		{
		if (shots[i].type == 0) {
			if ((i + 1) == num_shots) num_shots--;
			}
		if (shots[i].type != 0) {
		battletime = 1;
		if (shots[i].explode == 0) {
			shots[i].YVel -= gravity * nat_delay;
			XSetForeground(dpy, gc, XColors[0].pixel);
		
			XDrawPoint(dpy, mainwind, gc, shots[i].x, shots[i].y);
			shots[i].x += shots[i].XVel * nat_delay;
			shots[i].y -= shots[i].YVel * nat_delay;
                        if (shots[i].type != 1)
                        {
                                if ((shots[i].target == -1) && (shots[i].YVel  < 0) && ((shots[i].type == 2) || (shots[i].type == 3)))
                                
                                {
                                        shots[i].target = FindSmallestDistances(shots[i].owner);
                                        shots[i].locked = 1;
                                }
                                else if ((shots[i].target != -1) && (shots[i].type == 2))
                                {
                                        shots[i].XVel = shots[i].XVel + (5 * cos((2 * PI) - FindAnglets(i, shots[i].target)));
                                        shots[i].YVel = shots[i].YVel + (5 * sin((2 * PI) - FindAnglets(i, shots[i].target)));
                                        
                                }
                                else if ((shots[i].target != -1) && (shots[i].type == 3))
                                {
                                        tmp = shots[i].XVel;
                                        tmp1 = tanks[shots[i].target].cur_x - shots[i].x;
                                        
                                        tmp1 = tmp1 * 2;
                                        if (tmp > tmp1)
                                                shots[i].XVel = shots[i].XVel - 4;
                                        if (tmp < tmp1)
                                                shots[i].XVel = shots[i].XVel + 4;
                                }
                                else if ((shots[i].type == 6) && (shots[i].YVel < 0))
                                {

				}
			}			
			shots[i].XVel = shots[i].XVel - (wind - shots[i].XVel) * (wind
				- shots[i].XVel) * nat_delay * air_resist;
			shots[i].YVel = shots[i].YVel - (shots[i].YVel * shots[i].YVel)
					* air_resist * nat_delay;
			if (shots[i].x < 0) {
				if (lefteffect == 1)
				{
					shots[i].XVel *= -1;
					shots[i].x = 0;
					PlaySound(SND_BOUNCE);
				}
				if (lefteffect == 0) shots[i].explode = 1;
				}
			if (shots[i].y < 0) {
				if (topeffect == 1)
				{
					shots[i].YVel *= -1;
					shots[i].y = 0;
					PlaySound(SND_BOUNCE);
				}
				if (topeffect == 0) shots[i].explode = 1;
				}
			if (shots[i].y > height - 1) {
				if (bottomeffect == 1)
				{
					shots[i].YVel *= -1;
					shots[i].y = height - 2;
					PlaySound(SND_BOUNCE);
				} 
				else shots[i].explode = 1;
				}
			if (shots[i].x > width) {
				if (righteffect == 1)
				{
					shots[i].XVel *= -1;
					shots[i].x = width;
					PlaySound(SND_BOUNCE);
				}
				if (righteffect == 0) shots[i].explode = 1;
				}
			XSetForeground(dpy, gc, XColors[1].pixel);		
			conv_tmp = shots[i].x;
			conv_tmp2 = shots[i].y;
			XDrawPoint(dpy, mainwind, gc, conv_tmp, conv_tmp2);
			if ((shots[i].explode == 0) && (conv_tmp > 0) &&
				(conv_tmp2 > 0) &&
				(vline[conv_tmp].hpoint[conv_tmp2] > 0)) 
				shots[i].explode = 1;
				if (shots[i].explode == 1) PlaySound(SND_EXPLOS);
			}
			else if (shots[i].explode > 0) ExplodeShot(i);
		}	
	}
	if (battletime == 0) {
	if (!simultmode) {
		while(EarthFall(0, width));
		while(TankFall());
	}
	if (!CheckForLife()) return;
	}
                if ((simultmode || battletime)) {
                        if (fall_delay_counter == fall_delay )
                        {
                                fall_delay_counter = 0;
                        }
                        EarthFall(fall_delay_counter * (width / (float) fall_delay), (fall_delay_counter + 1) * (width / (float) fall_delay));
                        
                        fall_delay_counter++;
                        }

	if (simultmode || battletime) {
		TankFall();
	}

}



void QueryShot (int tank)
{
	double angler;
	int cur_shot = -1, i;


/*	if (simultmode && (tanks[tank].fire_delay > 0)) return; */
	if ((tanks[tank].cur_weap != 0) &&
		(tanks[tank].weapon[tanks[tank].cur_weap] <= 0)) {
		FindNextWeapon();
		return;
		}
	for(i = 1; (shots[i].type != 0) && (i < MAX_SHOTS);
		i++);
	cur_shot = i;
	if (i + 1 > num_shots) num_shots = i + 1;
	tanks[tank].fire_delay = firing_delay;	
        if (weapons[tanks[tank].cur_weap].type == 5) tanks[tank].guiding = i;
        if (tanks[tank].power > 500) PlaySound(SND_FFIRE);
                else PlaySound(SND_SFIRE);
	shots[cur_shot].type = weapons[tanks[tank].cur_weap].type;
	shots[cur_shot].radius = weapons[tanks[tank].cur_weap].radius;
        shots[cur_shot].arg = weapons[tanks[tank].cur_weap].arg;
        shots[cur_shot].target = -1;
	shots[cur_shot].explode = 0;
	shots[cur_shot].owner = tank;
	shots[cur_shot].XVel = sin(DegToRad(270 - tanks[tank].cur_angle)) *
		tanks[tank].power * 0.3;
	shots[cur_shot].YVel = cos(DegToRad(270 - tanks[tank].cur_angle)) *
		tanks[tank].power * -1 * 0.3;
	angler = DegToRad(tanks[tank].cur_angle);
	shots[cur_shot].x = tanks[tank].end_x;
	shots[cur_shot].y = tanks[tank].end_y;
	if (tanks[tank].cur_weap != 0)
	if (--tanks[tank].weapon[tanks[tank].cur_weap] <= 0) FindNextWeapon();
	if (tanks[tank].computer_type != 0) DrawText();
	tank_in_turn++;		
	while((tanks[tank_in_turn].max_power <= 0) && (tank_in_turn < number_of_tanks))
		tank_in_turn++;
	if ((!simultmode) && (tank_in_turn == number_of_tanks)) {
		tank_in_turn = 0;
		battletime = 1;
		}
}

